-module (process_chain).

-export ([timeFor/1, triggerElement/1, element/2]).

timeFor( ProcessCount ) ->
	{T, _} = timer:tc( ?MODULE, triggerElement, [ProcessCount] ),
	io:format( "time: ~p s~n", [T/1000000]).

triggerElement( ProcessCount ) ->
	PID = spawn( ?MODULE, element, [ProcessCount, self()] ),
	% io:format( "0~n" ),
	PID ! ping,
	receive
		ping ->
			% io:format( "0~n" ),
			PID ! ping,
			receive
				ping -> 
					% io:format("x"),
					ok 
			end
	end.

element( 1, First ) ->
	receive ping ->
		% io:format( "1~n" ),
		First ! ping,
		receive
			ping ->
				% io:format( "1~n" ),
				First ! ping 
		end
	end;
element( Remaining, First ) ->
	% io:format( "~p remaining (~p)~n", [Remaining, self()] ),
	receive
		ping ->
			% io:format( "~p~n", [Remaining] ),
			PID = spawn( ?MODULE, element, [Remaining - 1, First]),
			PID ! ping,
			receive ping ->
				% io:format( "~p~n", [Remaining] ),
				PID ! ping 
			end
	end.
			