/******************************************************************************
 * Název projektu: Aplet pro demonstraci Boyerova-Mooreova algoritmu
 * Balíček: boyermooredemo
 * Soubor: Algoritmus.java
 * Datum:  15.4.2008
 * Poslední změna: 18.4.2008
 * Autor:  Jaroslav Dytrych xdytry00
 *
 * Popis: Třída, kteá provádí vyhledávání řetězce v textu pomocí
 *        Boyerova-Mooreova algoritmu a ukládá informace do seznamu změn
 *        uživatelského rozhraní, které budou následně využity při vizualizaci.
 *             Jako počítadlo kroků využívá proměnnou pro počet kroků z appletu,
 *        čímž zajistí správnou hodnotu této proměnné po dokončení operace při
 *        ukončení v libovolném bodě.
 *             Aby se nevytvářely zbytečné instance konstant, využívá instanci 
 *        třídy konstant, kterou vlastní applet.
 *        
 ******************************************************************************/

/**
 * @file Algoritmus.java
 * 
 * @brief Třída Algoritmus - vyhledávání v řetězci a tvorba seznamu změn GUI
 */

package boyermooredemo;

import java.util.Iterator;
import java.util.TreeMap;

/**
 * Třída, kteá provádí vyhledávání řetězce v textu pomocí Boyerova-Mooreova 
 * algoritmu a ukládá informace do seznamu změn uživatelského rozhraní, 
 * které budou následně využity při vizualizaci.
 *      Jako počítadlo kroků využívá proměnnou pro počet kroků z appletu, čímž 
 * zajistí správnou hodnotu této proměnné po dokončení operace při ukončení 
 * v libovolném bodě.
 *      Aby se nevytvářely zbytečné instance konstant, využívá instanci třídy 
 * konstant, kterou vlastní applet.
 * 
 * @brief Vyhledávání v řetězci a tvorba seznamu změn GUI
 */
public class Algoritmus {
  /**
   * Reference na applet pro demonstraci algoritmu
   */
  private AppletBoyerMooreDemo ABMD;

  /** prohledávaný text */
  private char[] text;
  /** hledaný řetězec */
  private char[] pat;
  /** délka hledaného řetězce */
  private int m;
  /** délka prohledávaného textu */
  private int n;
  /** kontejner delta1 */
  private TreeMap<Character,Integer> delta1;
  /** delta1 pro znaky, které nejsou v kontejneru */
  private int delta1Jine;
  /** pole delta2 */
  private int[] delta2;
  /** pole shoda */
  private int[] shoda;
  
  /** pomocný kontejner pro vizualizaci - uchovává souřadnice v tabulce */
  private TreeMap<Character,Integer> poziceVDelta1;
  /** pomocná proměnná pro vizualizaci - počet položek v tabulce delta1 */
  private int pocetVDelta1;


  /**
   * Konstruktor třídy
   *
   * @param apABMD Reference na applet pro demonstraci algoritmu
   */
  public Algoritmus(AppletBoyerMooreDemo apABMD) 
  {
    ABMD = apABMD;  // uloží referenci na applet
  }
  
  /**
   * Metoda pro vyhledávání řetězce v textu a tvorbu seznamu změn uživatelského 
   * rozhraní pro vizualizaci. Nastavuje také počet kroků vizualizace ve třídě 
   * appletu.
   *
   * @param P Vyhledávaný řetězec
   * @param T Prohledávaný text
   * @return Vrací pozici vyhledávaného řetězce v prohledávaném textu, nebo -1, 
   *         pokud se řetězec v textu nevyskytuje.
   */
  public int BMA(String P, String T)
  {
    Integer pomI;  // pomocná proměnná pro zobrazení
    Character pomC;  // pomocná proměnná pro zobrazení
    int vypsano = 0;  // pomocná proměnná pro zobrazení - počet vypsaných znaků textu
    int posun = 0;  // pomocná proměnná pro zobrazení - posunutí v tabulce R
    int pomPosun = 0;  // pomocná proměnná pro zobrazení
    int pom;  // pomocná proměnná pro zobrazení
    int zvyrazneno = 0;  // pomocná proměnná pro zobrazení - počet zvýrazněných 
                         // sloupců v tabulce SR
    int presah;  // velikost tabulky SR je 3 * m + presah, přičemž 3*m je nezbytný 
                 // manipulační prostor a presah je pro větší přehlednost
    int pomITD1 = 1;  // pomocný index do tabulky delta1 pro vizualizaci
  

    m = P.length();  // délka hledaného řetězce
    
    // výpočet přesahu nutné velikosti tabulky SR
    if ((3*m+5) > ABMD.kon.TAB_SR_VR[1])
    {  // pokud je výchozí velikost tabulky malá (přesah 5 znaků by se nevešel)
      presah = 5;  // přesah bude 5 znaků
    }
    else
    {  // pokud je výchozí velikost tabulky dostatečná, jako přesah se využije
       // celá zbývající část tabulky
      presah = ABMD.kon.TAB_SR_VR[1] - 3*m;
    }
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - proměnná m, posun v algoritmu
    pomI = new Integer(m);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_M,pomI.toString()));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,11));


    pat = new char[m + 1];
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v alg., rozměry tabulky, i=0 do tabulky
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,13));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_R,
                                          ABMD.kon.TAB_D2,4,m+2));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                          ABMD.kon.TAB_D2,0,1,"0"));
    for (int i = 0; i < m; i++)
    {  // uloží hledaný řetězec do pole pat
      pat[i+1] = P.charAt(i);
      // uloží informace o změně zobrazení - i do tabulky
      pomI = new Integer(i+1);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_D2,0,i+2,pomI.toString()));
      // uloží informace o změně zobrazení - pat[i] do tabulky
      pomC = new Character(pat[i+1]);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_D2,1,i+2,pomC.toString()));
    }
    
    n = T.length();  // délka prohledávaného textu
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - proměnná n, posun v algoritmu
    pomI = new Integer(n);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_N,pomI.toString()));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,15));
    
    text = new char[n + 1];
    for (int i = 0; i < n; i++)
    {  // uloží prohledávaný řetězec do pole text
      text[i+1] = T.charAt(i);
    }
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v algoritmu
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,17));
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - záměna bloku, posun na správný řádek
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,
                                          ABMD.kon.ZADNY_RADEK));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_B,
                                          ABMD.kon.BLOK_DELTA1));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,42));
        
    vypocetDelta1();  // výpočet tabulky delta1
        
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - záměna bloku, posun na správný řádek
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,
                                          ABMD.kon.ZADNY_RADEK));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_B,
                                          ABMD.kon.BLOK_BMA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,20));

    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - záměna bloku, posun na správný řádek
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,
                                          ABMD.kon.ZADNY_RADEK));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_B,
                                          ABMD.kon.BLOK_DELTA2));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,54));

    vypocetDelta2();  // výpočet tabulky delta2
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - záměna bloku, posun na správný řádek, 
    // změna rozměrů tabulky SR
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,
                                          ABMD.kon.ZADNY_RADEK));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_B,
                                          ABMD.kon.BLOK_BMA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,21));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_R,
                                          ABMD.kon.TAB_SR,2,3*m+presah));
    
    int i = 1;  // pozice v textu
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu, změna popisků, nastavení proměnných, 
    // vložení řetězců do tabulky SR
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,23));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_PO,
                                          ABMD.kon.POPISEK_IJ,ABMD.kon.TEXTY_POPISKU_IPJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_PO,
                                          ABMD.kon.POPISEK_MJ,ABMD.kon.TEXTY_POPISKU_NM)); 
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_PO,
                                          ABMD.kon.POPISEK_L,ABMD.kon.TEXTY_POPISKU_D1P)); 
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,ABMD.kon.PROM_I,"1"));
    pomI = new Integer(n-m+1);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_MJ,"1"));
    for (int z = 0; z < m; z++)
    {  // vložení pat do tabulky SR
      pomC = new Character(pat[z+1]);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,0,z+m,pomC.toString()));
    }
    for (int z = 0; (z < (2*m+presah)) && (vypsano < n); z++)
    {  // vložení textu do tabulky SR
      pomC = new Character(text[z+1]);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,1,z+m,pomC.toString()));
      vypsano++;  // aktualizace počtu vypsaných znaků
    }
    
    int j = 1;  // pozice v pat, kvůli vizualizaci inicializována na 1, která se zahodí
    Integer d1P;  // pomocná delta1
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,26));
    
    
    while (i <= (n-m+1))
    {  
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - odbarvení buněk
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      for (int z = 3*m+presah-1; z >= 0; z--)
      {  // zkrácení zvýraznění na 1
        if ((z >= (2*m - 1)) && (z < (2*m)))
        {  // pokud má být buňka zvýrazněná
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_SR,0,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_SR,1,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        }
        else
        {  // pokud buňka nemá být zvýrazněná
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_SR,0,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,
                                                ABMD.kon.ZM_T_B,ABMD.kon.TAB_SR,1,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        }
      }  // zkrácení zvýraznění na 1
       
      j = m;
      
      // vizualizace - posun v algoritmu, nastavení proměnné
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,27));
      pomI = new Integer(j);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_J,pomI.toString()));
      pomI = new Integer(i+j-1);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_IJ,pomI.toString()));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
      
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu, zvýraznění v tabulce
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,28));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,j+m-1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,j+m-1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      zvyrazneno = 1;  // aktualizuje počet zvýrazněných sloupců
      
      while ((j >= 1) && (pat[j] == text[i+j-1]))
      {  // dokud do chází ke shodě, testuje další znaky
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - odbarvení buněk
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      
        j--;
        
        // vizualizace - posun v algoritmu, nastavení proměnných, úprava tabulek
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,29));
        pomI = new Integer(j);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_J,pomI.toString()));
        pomI = new Integer(i+j-1);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_IJ,pomI.toString()));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,0,j+m-1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,1,j+m-1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        zvyrazneno++;
      }  // dokud do chází ke shodě, testuje další znaky
      
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu, úprava tabulek
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,30));
      
      if (j == 0)
      {  // pokud byl řetězec nalezen
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, zrušení zvýraznění, nastavení proměnných
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,31));
        for (int z = 0; z < 3*m; z++)
        {  // zrušení zvýraznění v tabulce SR
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_SR,0,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_SR,1,z,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        }
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_I,""));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_J,""));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_IJ,""));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_MJ,""));
        pomI = new Integer(i-1);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_POZ,pomI.toString()));
      
        return i-1;  // řetězec v poli začíná o 1 dál
      }
      else
      {  // pokud řetězec nebyl nalezen
        d1P = delta1.get(text[i+j-1]);
        
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, úprava zvýraznění, nastavení proměnných
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,33));
        if (d1P != null)
        {  // pokud d1P není null
          pomI = new Integer(d1P);
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                                ABMD.kon.PROM_L,pomI.toString()));
          pomC = new Character(text[i+j-1]);
          pomITD1 = poziceVDelta1.get(pomC);
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,0,pomITD1,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,1,pomITD1,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        }
        else
        {  // pokud je d1P null
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                                ABMD.kon.PROM_L,"null"));
          pomITD1 = pocetVDelta1 - 1;
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,0,pomITD1,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,1,pomITD1,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        }
        
        if (d1P == null)
        {  // pokud se jedná o znak, který není v kontejneru
          d1P = delta1Jine;
          
          ABMD.pocetKroku++;  // vytvoření kroku vizualizace
          // vizualizace - posun v algoritmu, nastavení proměnné
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,35));
          pomI = new Integer(d1P);
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                                ABMD.kon.PROM_L,pomI.toString()));
        }
        i += Math.max(d1P, delta2[j]);  // posun
        
        pomPosun = Math.max(d1P, delta2[j]);  // uloží hodnotu posunu do pomocné proměnné
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, nastavení proměnných, úprava tabulek
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,36));
        pomI = new Integer(i);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_I,pomI.toString()));
        pomI = new Integer(i+j-1);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_IJ,pomI.toString()));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_L,""));
        posun += pomPosun;  // aktualizuje posun
        for (int z = 3*m+presah-1; z >= 0; z--)
        {  // posun zvýraznění vpřed
          if ((z > (2*m + pomPosun - zvyrazneno - 1)) && (z <= (2*m + pomPosun - 1)))
          {  // pokud má být buňka zvýrazněná
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                  ABMD.kon.TAB_SR,1,z,
                                                  ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
          }
          else
          {  // pokud buňka nemá být zvýrazněná
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                  ABMD.kon.TAB_SR,1,z,
                                                  ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
          }
        }  // posun zvýraznění vpřed
        
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - úprava tabulek
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D1,0,pomITD1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D1,1,pomITD1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        for (int z = 0; z < (3*m+presah); z++)
        {  // posun v tabulce SR
          pom = posun - m + 1 + z;
          if (pom <= 0)
          {  // pokud je v mezeře před vypisovaným řetězcem
            // vyprázdnění obsahu políčka
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                                  ABMD.kon.TAB_SR,1,z,""));
          }
          else if (pom <= n)
          {  // pokud je ve  vypisovaném řetězci
            pomC = new Character(text[pom]);
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                                  ABMD.kon.TAB_SR,1,z,pomC.toString()));
            vypsano++;  // aktualizace počtu vypsaných znaků
          }
          else
          {  // pokud je za vypisovaným řetězcem
            // vyprázdnění obsahu políčka
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                                  ABMD.kon.TAB_SR,1,z,""));
          }
        }  // posun v tabulce SR
        for (int z = 3*m+presah-1; z >= 0; z--)
        {  // posun zvýraznění zpět
          if ((z >= (2*m - zvyrazneno)) && (z < (2*m)))
          {  // pokud má být buňka zvýrazněná
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                  ABMD.kon.TAB_SR,1,z,
                                                  ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
          }
          else
          {  // pokud buňka nemá být zvýrazněná
            ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                  ABMD.kon.TAB_SR,1,z,
                                                  ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
          }
        }  // posun zvýraznění zpět
      }  // pokud řetězec nebyl nalezen
    }  // while (i <= (n-m+1))
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu, zrušení zvýraznění, nastavení proměnných
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,39));
    for (int z = 0; z < 3*m; z++)
    {  // zrušení zvýraznění v tabulce SR
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,z,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,z,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));          
    }
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,j+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,j+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_I,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_J,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_IJ,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_MJ,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_POZ,"-1"));
    return -1;  // řetězec nebyl nalezen
  }  // public int BMA()


  /**
   * Metoda pro výpočet tabulky delta1
   */
  private void vypocetDelta1()
  {
    Integer pomI;  // pomocná proměnná pro vizualizaci
    int pom = 1;  // pomocná proměnná pro vizualizaci
    int pocet = 2;  // počet sloupců tabulky delta1
    int zvyraznenySloupec = 1;  // číslo zvýrazněného sloupce v delta1
    
    // inicializace kontejneru
    delta1 = new TreeMap<Character,Integer>();
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
     // uloží informace o změně zobrazení - posun v algoritmu, změna rozměrů tabulky delta1
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,44));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_R,
                                          ABMD.kon.TAB_D1,2,pocet));
    
    // výpočet pole delta1 (pro velký počet možných znaků je zde toto pole
    // nahrazeno kontejnerem pro uvedené znaky a proměnnou pro hodnotu
    // delta1 neuvedených (jiných) znaků)
    for (int i = 1; i <= m; i++)
    {  // výpočet delta1
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // zobrazení - zrušení zvýraznění buněk z minulého cyklu
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,pom+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,pom+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA)); 
      
      delta1.put(pat[i],(m-i));  // výpočet delta1
      
      // zobrazení - posun v algoritmu, výpis i, zvýraznění v tabulce delta2, 
      // výpis tabulky delta1
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,49));
      pomI = new Integer(i);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_I,pomI.toString()));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,i+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,i+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
      pom = 1;
      pocet = 2;
      for (Iterator pomIter = delta1.keySet().iterator(); pomIter.hasNext();)
      {  // výpis tabulky delta1
        pocet++;  // výpočet počtu sloupců tabulky
        Character pismeno = (Character)pomIter.next();
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                              ABMD.kon.TAB_D1,0,pom,pismeno.toString()));
        pomI = delta1.get(pismeno);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                              ABMD.kon.TAB_D1,1,pom,pomI.toString()));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D1,0,pom,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D1,1,pom,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        if (pat[i] == pismeno)
        {  // pokud se má sloupec zvýraznit
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,0,pom,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
          ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                                ABMD.kon.TAB_D1,1,pom,
                                                ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
          zvyraznenySloupec = pom;
        }
        pom++;  // posun na další sloupec
      }  // výpis tabulky delta1
      // zvětšení tabulky delta1
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_R,
                                            ABMD.kon.TAB_D1,2,pocet));
      pom = i;
    }  // výpočet delta1
    
    // uložení informací pro vizualizaci
    pocetVDelta1 = pocet;  // počet sloupců tabulky
    poziceVDelta1 = new TreeMap<Character,Integer>();  // inicializace kontejneru pro pozice v tabulce
    int pomV = 1;
    for (Iterator pomIter = delta1.keySet().iterator(); pomIter.hasNext();)
    {  // uložení tabulky delta1
      Character pismeno = (Character)pomIter.next();
      poziceVDelta1.put(pismeno,pomV);
      pomV++;
    }
    
    delta1Jine = m;
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v algoritmu, odbarvení zvýraznění, 
    // vyprázdnění i, přidání položky pro jiné znaky do delta1
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,51));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,ABMD.kon.PROM_I,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D1,0,zvyraznenySloupec,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D1,1,zvyraznenySloupec,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,pom+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,1,pom+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                          ABMD.kon.TAB_D1,0,pocet-1,ABMD.kon.JINE_ZNAKY));
    pomI = new Integer(m);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                          ABMD.kon.TAB_D1,1,pocet-1,pomI.toString()));
  }  // private void vypocetDelta1()


  /**
   * Metoda pro výpočet tabulky delta2
   */
  private void vypocetDelta2()
  {  
    Integer pomI;  // pomocná proměnná pro vizualizaci
    Character pomC;  // pomocná proměnná pro vizualizaci
    int posun = 1;  // pomocná proměnná pro vizualizaci - posun 2. řádku tabulky SR
    // nastavení rozměrů tabulky SR pro vizualizaci hledání podřetězců
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_R,
                                          ABMD.kon.TAB_SR,2,2*m+1));
  
    // inicializace polí
    delta2 = new int[m+1];
    shoda = new int[m+1];
    shoda[m] = 0;
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v algoritmu, nastavení shoda[m], obarvení
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,58));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,m+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                          ABMD.kon.TAB_D2,2,m+1,"0"));
    
    delta2[m] = 1;
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v algoritmu, odbarvení shoda[m], 
    // nastavení a obarvení delta2[m]
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,59));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,m+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,m+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_I));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                          ABMD.kon.TAB_D2,3,m+1,"1"));
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - posun v algoritmu, odbarvení delta2[m],
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,60));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,m+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
     
    pomI = new Integer(m); // pomocná proměnná pro převod do řetězce
     
    for (int j = 0; j <= (m-1); j++)
    {
      shoda[j] = 1;
      delta2[j] = m;
      // uloží informace o změně zobrazení - nastavení obsahů buněk (všechny v 1 kroku)
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_D2,2,j+1,"1"));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_D2,3,j+1,pomI.toString()));
      // uloží informace o změně zobrazení - obarvení 
      // - všechny buňky budou nastaveny v 1 kroku
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
    }

    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // uloží informace o změně zobrazení - odbarvení 
    for (int j = 0; j <= (m-1); j++)
    {  // obarvení - všechny buňky budou nastaveny v 1 kroku vizualizace
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    }
    

    // fáze 1: hledání podřetězců shodných s koncem pat
    int j = 1;  // index, od kterého se pat kontroluje
    
    // uloží informace o změně zobrazení - nastaví j a m-j+1, posun v algoritmu, 
    // zvýraznění buněk v tabulce
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,65));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,ABMD.kon.PROM_J,"1"));
    pomI = new Integer(m-j+1);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_MJ,pomI.toString()));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,1,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
    
    int i = m-1;  // počet shodných znaků
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    pomI = new Integer(i); // pomocná proměnná pro převod do řetězce
    // uloží informace o změně zobrazení - nastaví 1 a i-j+1, posun v algoritmu, 
    // zvýraznění buněk v tabulce
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,66));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_I,pomI.toString()));
    pomI = new Integer(i-j+1);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_IJ,pomI.toString()));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,i-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,1,i-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,i-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,67));
    for (int z = 0; z < m; z++)
    {  // vizualizace - výpis pat do tabulky SR
      pomC = new Character(pat[z+1]);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,0,z+1,pomC.toString()));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,1,z+1+posun,pomC.toString()));
    } 
        
    while (i >= j)
    {
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu, úprava zvýraznění buněk v tabulce SR
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,68));
      for (int z = 0; z < (2*m+1); z++)
      {  // odbarvení buněk
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,0,z,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,1,z,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      }
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,m-j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,i-j+1+posun,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
    
      while ((i >= j) && (pat[m-j+1] == pat[i-j+1]))
      {  // nalezení nejdelší shody
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, odbarvení buněk
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,69));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
       
        j++;

        // vizualizace - úprava tabulek a proměnných
        pomI = new Integer(j);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_J,pomI.toString()));
        pomI = new Integer(i-j+1);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_IJ,pomI.toString()));
        pomI = new Integer(m-j+1);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_MJ,pomI.toString()));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));        
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,m-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,0,m-j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,1,i-j+1+posun,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        shoda[i-j+1] = j;
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, úprava tabulek
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,70));
        pomI = new Integer(j);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                              ABMD.kon.TAB_D2,2,i-j+2,pomI.toString()));
      }  // while ((i >= j) && ...
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,72));
      if (j > 1)
      {  // pokud byla nalezena shoda, provede aktualizaci
        delta2[m-j+1] = Math.min(m-i, delta2[m-j+1]);
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, úprava tabulky
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,73));
        pomI = new Integer(delta2[m-j+1]);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                              ABMD.kon.TAB_D2,3,m-j+2,pomI.toString()));
      }
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - odbarvení zvýrazněných buněk
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      for (int z = 0; z < (2*m+1); z++)
      {  // odbarvení buněk
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,0,z,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_SR,1,z,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      }
      
      pomI = new Integer(i);  // původní hodnota i pro posun tabulky
      
      i = i-j+shoda[m-j+1];
      
      // vizualizace - posun v algoritmu, úprava tabulek a proměnných
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_P,
                                            ABMD.kon.TAB_SR,1,
                                            ABMD.kon.POSUN_VPRAVO,pomI-i));
      posun += pomI-i;
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,74));
      if (i-j+2 > 0)
      {  // pokud souřadnice nejsou mimo tabulku
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      }
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,m-j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,i-j+1+posun,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));

      pomI = new Integer(i);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_I,pomI.toString()));
      pomI = new Integer(i-j+1);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_IJ,pomI.toString()));
      
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - odbarvení zvýrazněných buněk
      if (i-j+2 > 0)
      {  // pokud souřadnice nejsou mimo tabulku
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,1,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,2,i-j+2,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      }
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,m-j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,i-j+1+posun,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      
      j = Math.max(shoda[m-j+1],1);
      
      // vizualizace - posun v algoritmu, úprava tabulek a proměnných
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,75));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,3,m-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,m-j+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_MJ));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,i-j+1+posun,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_IJ));
      pomI = new Integer(j);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_J,pomI.toString()));
      pomI = new Integer(i-j+1);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_IJ,pomI.toString()));
      pomI = new Integer(m-j+1);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_MJ,pomI.toString()));
    }  // while (i >= j)

    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - odbarvení zvýrazněných buněk, vyprázdnění tabulky SR, 
    // vyprázdnění nepotřebných proměnných
    for (int z = 0; z < (2*m+1); z++)
    {  // odbarvení a vyprázdnění buněk
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,0,z,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_SR,1,z,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,0,z,""));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                            ABMD.kon.TAB_SR,1,z,""));
    }
    if (i-j+2 > 0)
    {  // pokud souřadnice nejsou mimo tabulku
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,1,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,i-j+2,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    }
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,1,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,m-j+2,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_MJ,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_IJ,""));

    // fáze 2: výpočet tabulky posunutí
    int t = shoda[0];  // délka shodného řetězce s koncem pat
    // vizualizace - posun v algoritmu, nastavení proměnné, zvýraznění
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,78));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_T));
    pomI = new Integer(shoda[0]);
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_T,pomI.toString()));

    int L = 1;  // aktuální znak pat
    
    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu, nastavení proměnné, zvýraznění
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,79));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_L,"1"));
    
    int s = 1;  // maximální posunutí úseku, hodnota 1 doplněna pro vizualizaci
    while (t > 0)
    {
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - odbarvení zvýrazněných buněk
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,s+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    
      s = m-t+1;
      
      // vizualizace - posun v algoritmu, nastavení proměnné, zvýraznění
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,82));
      pomI = new Integer(s);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_S,pomI.toString()));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,0,s+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_S));
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                            ABMD.kon.TAB_D2,2,s+1,
                                            ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_S));
      
      for (j = L; j <= s; j++)
      {
        delta2[j] = Math.min(delta2[j], s);
        
        ABMD.pocetKroku++;  // vytvoření kroku vizualizace
        // vizualizace - posun v algoritmu, úprava proměnné, 
        // odbarvení zvýrazněných buněk úprava tabulky, zvýraznění
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,84));
        pomI = new Integer(j);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                              ABMD.kon.PROM_J,pomI.toString()));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,j,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,j,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,0,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                              ABMD.kon.TAB_D2,3,j+1,
                                              ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_J));
        pomI = new Integer(delta2[j]);
        ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_H,
                                              ABMD.kon.TAB_D2,3,j+1,pomI.toString()));
      }  // for (j = L; j <= s; j++)
      
      t = shoda[s];
      
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu, nastavení proměnné
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,86));
      pomI = new Integer(shoda[s]);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_T,pomI.toString()));
      
      L = s+1;
      
      ABMD.pocetKroku++;  // vytvoření kroku vizualizace
      // vizualizace - posun v algoritmu, odbarvení zvýrazněných buněk, nastavení proměnné
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,87));
      pomI = new Integer(L);
      ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                            ABMD.kon.PROM_L,pomI.toString()));
    }  // while (t > 0)

    ABMD.pocetKroku++;  // vytvoření kroku vizualizace
    // vizualizace - posun v algoritmu, odbarvení zvýrazněných buněk v tabulkách, 
    // vyprázdnění proměnných
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_A_Z,89));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,0,j,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,3,j,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_T_B,
                                          ABMD.kon.TAB_D2,2,s+1,
                                          ABMD.kon.BARVA_CERNA,ABMD.kon.BARVA_BILA));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_I,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_J,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_S,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_T,""));
    ABMD.prubehViz.add(new ZmenaZobrazeni(ABMD.pocetKroku,ABMD.kon.ZM_P,
                                          ABMD.kon.PROM_L,""));
  }  // private void vypocetDelta2()
  
}  // public class Algoritmus

 /*** Konec souboru Algoritmus.java ***/
 