/******************************************************************************
 * Název projektu: Aplet pro demonstraci Boyerova-Mooreova algoritmu
 * Balíček: boyermooredemo
 * Soubor: Konstanty.java
 * Datum:  11.4.2008
 * Poslední změna: 18.4.2008
 * Autor:  Jaroslav Dytrych xdytry00
 *
 * Popis: Třída s konstantami (barvy, čísla prvků, texty do panelů, ...)
 *
 ******************************************************************************/

/**
 * @file Konstanty.java
 * 
 * @brief Třída Konstanty - třída s konstantami
 */

package boyermooredemo;

import java.awt.Color;

/**
 * Třída s konstantami (barvy, čísla prvků, texty do panelů, ...)
 * 
 * @brief Třída s konstantami
 */
public class Konstanty {
  /** Barvy pro textové pole s algoritmem - barva zvýrazněného textu */
  public static final Color BARVA_ZVYRAZNENI_T = new Color(255,255,255);
  /** Barvy pro textové pole s algoritmem - barva pozadí zvýrazněného textu */
  public static final Color BARVA_ZVYRAZNENI_P = new Color(26,6,153);
  /** Barvy pro textové pole s algoritmem - barva komentářů */
  public static final Color BARVA_KOMENTARU = new Color(118,118,249);
  /** Barvy pro textové pole s algoritmem - barva datových typů a modifikátorů */
  public static final Color BARVA_TYPU = new Color(46,139,87);
  /** Barvy pro textové pole s algoritmem - barva klíčových slov řídících struktur */
  public static final Color BARVA_RIDICICH = new Color(165,42,42);
  /** Barvy pro textové pole s algoritmem - barva literálů */
  public static final Color BARVA_LITERALU = new Color(255,59,252);  
  /** Barvy pro textové pole s algoritmem - barva zbylého textu (identifikátory, ...) */
  public static final Color BARVA_CERNA = new Color(0,0,0);
   /** Barvy pro textové pole s algoritmem - barva pozadí */
  public static final Color BARVA_BILA = new Color(255,255,255);

  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná i */
  public static final Color BARVA_I = new Color(99, 255, 99);
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná j */
  public static final Color BARVA_J = new Color(115, 255, 255);
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná i-j+1 */
  public static final Color BARVA_IJ = new Color(255, 255, 66);
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná m-j+1 */
  public static final Color BARVA_MJ = new Color(255, 165, 165);
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná s */
  public static final Color BARVA_S = new Color(255, 165, 214);  
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná t */
  public static final Color BARVA_T = new Color(198, 198, 255);  
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná L */
  public static final Color BARVA_L = new Color(255, 222, 214);  
  /** Barvy pro zvýrazňování v tabulkách - barvy proměnných - proměnná poz */
  public static final Color BARVA_POZ = new Color(255, 181, 99);  
  
  /** Operace změn v GUI (vizualizace) - změna hodnoty políčka v tabulce */
  public static final int ZM_T_H = 1;
  /** Operace změn v GUI (vizualizace) - změna barvy políčka v tabulce */
  public static final int ZM_T_B = 2;
  /** Operace změn v GUI (vizualizace) - posun řádku tabulky */
  public static final int ZM_T_P = 3;
  /** Operace změn v GUI (vizualizace) - změna rozměrů tabulky */
  public static final int ZM_T_R = 4;
  /** Operace změn v GUI (vizualizace) - výměna bloku v panelu s algoritmem */
  public static final int ZM_A_B = 5;
  /** Operace změn v GUI (vizualizace) - změna zvýrazněného řádku v poli s algoritmem */
  public static final int ZM_A_Z = 6;
  /** Operace změn v GUI (vizualizace) - změna hodnoty proměnné */
  public static final int ZM_P = 7;
  /** Operace změn v GUI (vizualizace) - změna obsahu pole s nápovědou */
  public static final int ZM_N = 8;
  /** Operace změn v GUI (vizualizace) - změna popisku */
  public static final int ZM_PO = 9;
  
  /** Tabulky - tabulkaSR  */
  public static final int TAB_SR = 1;
  /** Tabulky - tabulkaDelta1  */
  public static final int TAB_D1 = 2;
  /** Tabulky - tabulkaDelta2  */
  public static final int TAB_D2 = 3;
  
  /** Políčka s proměnnými - jTextFieldm (proměnná m) */
  public static final int PROM_M = 1;
  /** Políčka s proměnnými - jTextFieldn (proměnná n) */
  public static final int PROM_N = 2;
  /** Políčka s proměnnými - jTextFieldi (proměnná i) */
  public static final int PROM_I = 3;
  /** Políčka s proměnnými - jTextFieldj (proměnná j) */
  public static final int PROM_J = 4;
  /** Políčka s proměnnými - jTextFieldij (proměnná i-j+1) */
  public static final int PROM_IJ = 5;
  /** Políčka s proměnnými - jTextFieldmj (proměnná m-j+2) */
  public static final int PROM_MJ = 6;
  /** Políčka s proměnnými - jTextFields (proměnná s) */
  public static final int PROM_S = 7;
  /** Políčka s proměnnými - jTextFieldt (proměnná s) */
  public static final int PROM_T = 8;
  /** Políčka s proměnnými - jTextFieldL (proměnná L) */
  public static final int PROM_L = 9;
  /** Políčka s proměnnými - jTextFieldpoz (proměnná poz) */
  public static final int PROM_POZ = 10;
  
  /** Měnitelné popisky - popisek jLabelij (má varianty i-j+1 a i+j-1) */
  public static final int POPISEK_IJ = 1;
  /** Měnitelné popisky - popisek jLabelmj (má varianty m-j+1 a n-m+1) */
  public static final int POPISEK_MJ = 2;
  /** Měnitelné popisky - popisek jLabelL (má varianty L a d1P)*/
  public static final int POPISEK_L = 3;
  
  /** Texty na měnitelné popisky - popisek jLabelij - varianta i-j+1 */
  public static final String TEXTY_POPISKU_IMJ = "i-j+1 = ";
  /** Texty na měnitelné popisky - popisek jLabelij - varianta i+j-1 */
  public static final String TEXTY_POPISKU_IPJ = "i+j-1 = ";
  /** Texty na měnitelné popisky - popisek jLabelmj - varianta m-j+1 */
  public static final String TEXTY_POPISKU_MJ = "m-j+1 = ";
  /** Texty na měnitelné popisky - popisek jLabelmj - varianta n-m+1 */
  public static final String TEXTY_POPISKU_NM = "n-m+1 = ";
  /** Texty na měnitelné popisky - popisek jLabelL - varianta L */
  public static final String TEXTY_POPISKU_L = "     L = ";
  /** Texty na měnitelné popisky - popisek jLabelL - varianta d1p */
  public static final String TEXTY_POPISKU_D1P = "d1P = ";
  
  /** Konstanta pro směr posunu vlevo */
  public static final int POSUN_VLEVO = 0;
  /** Konstanta pro směr posunu vpravo */
  public static final int POSUN_VPRAVO = 1;
  
  /** Výchozí rozměry tabulky tabulkaSR */
  public static final int[] TAB_SR_VR = {2,36};
  /** Výchozí rozměry tabulky delta1 */
  public static final int[] TAB_D1_VR = {2,22};
  /** Výchozí rozměry tabulky delta2 */
  public static final int[] TAB_D2_VR = {4,22};
  
  /**
   * Pole s nápovědami
   */
  public static final String[] textyNapovedy = {
    /* 0 */ "Návod k použití:\n" + 
            "1. zadejte hledaný řetězec a prohledávaný text\n" + 
            "2. zahajte vizualizaci kliknutím na tlačítko \"Vpřed\"\n" + 
            "3. prohlížejte si vizualizaci klikáním na tlačítka \"Vpřed\" a \"Zpět\"\n" + 
            "4. chcete-li zadat jiný hledaný řetězec, nebo prohledávaný text,\n" + 
            "    klikněte na tlačítko \"Reset\" a upravte řetězce dle potřeby",
    /* 1 */ "Nyní si můžete prohlížet vizualizaci algoritmu pomocí tlačítek\n" + 
            "\"Vpřed\" (provede další krok vizualizace) a \"Zpět\" (návrat o 1 krok). \n" + 
            "     Chcete-li změnit vyhledávaný řetězec, nebo prohledávaný text, \n" + 
            "klikněte na tlačítko \"Reset\", upravte řetězce dle potřeby a znovu\n" + 
            "spusťte vizualizaci."
  };  // textyNapovedy
  
  /**
   * Pole s jednotlivými úseky zdrojového textu algoritmu
   */
  public static final String[] textyAlgoritmu = {
    /* Deklarace proměnných  */
    /*  0:  0 -  2 */ "private char","[] text;  ","// prohledávaný text\n",
    /*  1:  3 -  5 */ "private char","[] pat;  ","// hledaný řetězec\n",
    /*  2:  6 -  8 */ "private int ","m;  ","// délka hledaného řetězce\n",
    /*  3:  9 - 11 */ "private int ","n;  ","// délka prohledávaného textu\n",
    /*  4: 12 - 14 */ "private ","TreeMap<Character,Integer> delta1;  ","// kontejner delta1\n",
    /*  5: 15 - 17 */ "private int ","delta1Jine;  ","// delta1 pro znaky, které nejsou v kontejneru\n",
    /*  6: 18 - 19 */ "private int","[] delta2;\n",
    /*  7: 20 - 21 */ "private int","[] shoda;\n",
    /*  8:      22 */ "  \n",
    /* Metoda BMA */
    /*  9: 23 - 24 */ "public int"," BMA(String P, String T) {\n",
    /* 10:      25 */ "  // inicializace\n",
    /* 11: 26 - 27 */ "  m = P.length();  ","// délka hledaného řetězce\n",
    /* 12: 28 - 33 */ "  pat = ","new ","char","[m + ","1","];\n",
    /* 13: 34 - 40 */ "  for ","(","int"," i = ","0","; i < m; i++)  ","// uloží hledaný řetězec do pole pat\n",
    /* 14: 41 - 43 */ "    pat[i+","1","] = P.charAt(i);\n",
    /* 15: 44 - 45 */ "  n = T.length();  ","// délka prohledávaného textu\n",
    /* 16: 46 - 51 */ "  text = ","new ","char","[n + ","1","];\n",
    /* 17: 52 - 58 */ "  for ","(","int ","i = ","0","; i < n; i++)  ","// uloží prohledávaný řetězec do pole\n",
    /* 18: 59 - 61 */ "    text[i+","1","] = T.charAt(i);\n",
    /* 19:      62 */ "  \n",
    /* 20: 63 - 64 */ "  vypocetDelta1();  ","// výpočet tabulky delta1\n",
    /* 21: 65 - 66 */ "  vypocetDelta2();  ","// výpočet tabulky delta2\n",
    /* 22:      67 */ "  \n",
    /* 23: 68 - 72 */ "  int ","i = ","1",";  ","// pozice v textu\n",
    /* 24: 73 - 75 */ "  int ","j;  ","// pozice v pat\n",
    /* 25: 76 - 77 */ "  Integer d1P;  ","// pomocná delta1\n",
    /* 26: 78 - 81 */ "  while"," (i <= (n-m+","1",")) {  \n",
    /* 27:      82 */ "    j = m;\n",
    /* 28: 83 - 89 */ "    while ","((j >= ","1",") && (pat[j] == text[i+j-","1","]))  ","// dokud do chází ke shodě\n",
    /* 29: 90 - 91 */ "      j--;  ","// posun na další znak (testuje od konce)\n",
    /* 30: 92 - 96 */ "    if ","(j == ","0",")  ","// pokud byl řetězec nalezen\n",
    /* 31:  97 - 101 */ "      return ","i-","1",";  ","// řetězec v poli začíná o 1 dál\n",
    /* 32: 102 - 104 */ "    else ","{  ","// pokud řetězec nebyl nalezen\n",
    /* 33: 105 - 107 */ "      d1P = delta1.get(text[i+j-","1","]);\n",
    /* 34: 108 - 112 */ "      if ","(d1P == ","null",")  ","// pokud se jedná o znak, který není v kontejneru\n",
    /* 35:       113 */ "        d1P = delta1Jine;\n",
    /* 36: 114 - 115 */ "      i += Math.max(d1P, delta2[j]);  ","// posun\n",
    /* 37:       116 */ "    }\n",
    /* 38:       117 */ "  }\n",
    /* 39: 118 - 121 */ "  return ","-1",";  ","// řetězec nebyl nalezen\n",
    /* 40: 122 - 123 */ "}  ","// public int BMA()\n",
    /* 41:       124 */ "  \n",
    /* Metoda pro výpočet delta1 */
    /* 42: 125 - 126 */ "private void ","vypocetDelta1()  {\n",
    /* 43:       127 */ "  // inicializace kontejneru\n",
    /* 44: 128 - 130 */ "  delta1 = ","new ","TreeMap();\n",
    /* 45:       131 */ "  // výpočet pole delta1 (pro velký počet možných znaků je zde toto pole\n",
    /* 46:       132 */ "  // nahrazeno kontejnerem pro uvedené znaky a proměnnou pro hodnotu\n",
    /* 47:       133 */ "  // delta1 neuvedených (jiných) znaků)\n",    
    /* 48: 134 - 140 */ "  for ","(","int ","i = ","1","; i <= m; i++) {  ","// výpočet delta1\n",
    /* 49:       141 */ "    delta1.put(pat[i],(m-i));\n",
    /* 50:       142 */ "  }\n",        
    /* 51:       143 */ "  delta1Jine = m;\n",    
    /* 52: 144 - 145 */ "}  ","// private void vypocetDelta1()\n",
    /* 53:       146 */ "  \n",
    /* Metoda pro výpočet delta2 */
    /* 54: 147 - 148 */ "private void ","vypocetDelta2() {\n",
    /* 55:       149 */ "  // inicializace polí\n",
    /* 56: 150 - 155 */ "  delta2 = ","new ","int","[m+","1","];\n",
    /* 57: 156 - 161 */ "  shoda = ","new ","int","[m+","1","];\n",
    /* 58: 162 - 164 */ "  shoda[m] = ","0",";\n",
    /* 59: 165 - 167 */ "  delta2[m] = ","1",";\n",
    /* 60: 168 - 175 */ "  for ","(","int ","j = ","0","; j <= (m-","1","); j++)  {\n",
    /* 61: 176 - 178 */ "    shoda[j] = ","1",";\n",
    /* 62:       179 */ "    delta2[j] = m;\n",
    /* 63:       180 */ "  }\n",
    /* 64:       181 */ "  // fáze 1: hledání podřetězců shodných s koncem pat\n",
    /* 65: 182 - 186 */ "  int ","j = ","1",";  ","// index, od kterého se pat kontroluje\n",
    /* 66: 187 - 191 */ "  int ","i = m-","1",";  ","// počet shodných znaků\n",
    /* 67: 192 - 193 */ "  while ","(i >= j) {\n",
    /* 68: 194 - 200 */ "    while ","((i >= j) && (pat[m-j+","1","] == pat[i-j+","1","])) {  ","// hlední nejdelší shody\n",
    /* 69:       201 */ "      j++;\n",
    /* 70: 202 - 204 */ "      shoda[i-j+","1","] = j;\n",
    /* 71:       205 */ "    }\n",
    /* 72: 206 - 210 */ "    if ","(j > ","1",") ","// pokud byla nalezena shoda, provede aktualizaci\n",
    /* 73: 211 - 215 */ "      delta2[m-j+","1","] = Math.min(m-i, delta2[m-j+","1","]);\n",
    /* 74: 216 - 218 */ "    i = i-j+shoda[m-j+","1","];\n",
    /* 75: 219 - 223 */ "    j = Math.max(shoda[m-j+","1","],","1",");\n",
    /* 76:       224 */ "  }\n",
    /* 77:       225 */ "  // fáze 2: výpočet tabulky posunutí\n",
    /* 78: 226 - 230 */ "  int ","t = shoda[","0","];  ","// délka shodného řetězce s koncem pat\n",
    /* 79: 231 - 235 */ "  int ","L = ","1",";  ","// aktuální znak pat\n",
    /* 80: 236 - 238 */ "  int ","s;  ","// maximální posunutí úseku\n",
    /* 81: 239 - 242 */ "  while ","(t > ","0",") {\n",
    /* 82: 243 - 245 */ "    s = m-t+","1",";\n",
    /* 83: 246 - 247 */ "    for ","(j = L; j <= s; j++) {\n",
    /* 84:       248 */ "      delta2[j] = Math.min(delta2[j], s);\n",
    /* 85:       249 */ "    }\n",
    /* 86:       250 */ "    t = shoda[s];\n",
    /* 87: 251 - 253 */ "    L = s+","1",";\n",
    /* 88:       254 */ "  }\n",
    /* 89: 255 - 256 */ "}  ","// private void vypocetDelta2()"
  };  // textyAlgoritmu
  
  
  /**
   * Pole s barvami jednotlivých úseků textu algoritmu
   */
  public static final Color[] barvyAlgoritmu = {
    /* Deklarace proměnných  */
    /*  0:  0 -  2 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  1:  3 -  5 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  2:  6 -  8 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  3:  9 - 11 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  4: 12 - 14 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  5: 15 - 17 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /*  6: 18 - 19 */ BARVA_TYPU,BARVA_CERNA,
    /*  7: 20 - 21 */ BARVA_TYPU,BARVA_CERNA,
    /*  8:      22 */ BARVA_CERNA,
    /* Metoda BMA */
    /*  9: 23 - 24 */ BARVA_TYPU,BARVA_CERNA,
    /* 10:      25 */ BARVA_KOMENTARU,
    /* 11: 26 - 27 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 12: 28 - 33 */ BARVA_CERNA,BARVA_RIDICICH,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 13: 34 - 40 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 14: 41 - 43 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 15: 44 - 45 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 16: 46 - 51 */ BARVA_CERNA,BARVA_RIDICICH,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 17: 52 - 58 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 18: 59 - 61 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 19:      62 */ BARVA_CERNA,
    /* 20: 63 - 64 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 21: 65 - 66 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 22:      67 */ BARVA_CERNA,
    /* 23: 68 - 72 */ BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 24: 73 - 75 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 25: 76 - 77 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 26: 78 - 81 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 27:      82 */ BARVA_CERNA,
    /* 28: 83 - 89 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 29: 90 - 91 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 30: 92 - 96 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 31:  97 - 101 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 32: 102 - 104 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_KOMENTARU,
    /* 33: 105 - 107 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 34: 108 - 112 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 35:       113 */ BARVA_CERNA,
    /* 36: 114 - 115 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 37:       116 */ BARVA_CERNA,
    /* 38:       117 */ BARVA_CERNA,
    /* 39: 118 - 121 */ BARVA_RIDICICH,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 40: 122 - 123 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 41:       124 */ BARVA_CERNA,
    /* Metoda pro výpočet delta1 */
    /* 42: 125 - 126 */ BARVA_TYPU,BARVA_CERNA,
    /* 43:       127 */ BARVA_KOMENTARU,
    /* 44: 128 - 130 */ BARVA_CERNA,BARVA_RIDICICH,BARVA_CERNA,
    /* 45:       131 */ BARVA_KOMENTARU,
    /* 46:       132 */ BARVA_KOMENTARU,
    /* 47:       133 */ BARVA_KOMENTARU,
    /* 48: 134 - 140 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 49:       141 */ BARVA_CERNA,
    /* 50:       142 */ BARVA_CERNA,
    /* 51:       143 */ BARVA_CERNA,
    /* 52: 144 - 145 */ BARVA_CERNA,BARVA_KOMENTARU,
    /* 53:       146 */ BARVA_CERNA,
    /* Metoda pro výpočet delta2 */
    /* 54: 147 - 148 */ BARVA_TYPU,BARVA_CERNA,
    /* 55:       149 */ BARVA_KOMENTARU,
    /* 56: 150 - 155 */ BARVA_CERNA,BARVA_RIDICICH,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 57: 156 - 161 */ BARVA_CERNA,BARVA_RIDICICH,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 58: 162 - 164 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 59: 165 - 167 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 60: 168 - 175 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 61: 176 - 178 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 62:       179 */ BARVA_CERNA,
    /* 63:       180 */ BARVA_CERNA,
    /* 64:       181 */ BARVA_KOMENTARU,
    /* 65: 182 - 186 */ BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 66: 187 - 191 */ BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 67: 192 - 193 */ BARVA_RIDICICH,BARVA_CERNA,
    /* 68: 194 - 200 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 69:       201 */ BARVA_CERNA,
    /* 70: 202 - 204 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 71:       205 */ BARVA_CERNA,
    /* 72: 206 - 210 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 73: 211 - 215 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 74: 216 - 218 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 75: 219 - 223 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 76:       224 */ BARVA_CERNA,
    /* 77:       225 */ BARVA_KOMENTARU,
    /* 78: 226 - 230 */ BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 79: 231 - 235 */ BARVA_TYPU,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 80: 236 - 238 */ BARVA_TYPU,BARVA_CERNA,BARVA_KOMENTARU,
    /* 81: 239 - 242 */ BARVA_RIDICICH,BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 82: 243 - 245 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 83: 246 - 247 */ BARVA_RIDICICH,BARVA_CERNA,
    /* 84:       248 */ BARVA_CERNA,
    /* 85:       249 */ BARVA_CERNA,
    /* 86:       250 */ BARVA_CERNA,
    /* 87: 251 - 253 */ BARVA_CERNA,BARVA_LITERALU,BARVA_CERNA,
    /* 88:       254 */ BARVA_CERNA,
    /* 89: 255 - 256 */ BARVA_CERNA,BARVA_KOMENTARU
  };  // barvyAlgoritmu
  
  
  /**
   * Pole s označeními tučných úseků textu algoritmu
   */
  public static final boolean[] tucneCastiAlgoritmu = {
    /* Deklarace proměnných  */
    /*  0:  0 -  2 */ true,false,false,
    /*  1:  3 -  5 */ true,false,false,
    /*  2:  6 -  8 */ true,false,false,
    /*  3:  9 - 11 */ true,false,false,
    /*  4: 12 - 14 */ true,false,false,
    /*  5: 15 - 17 */ true,false,false,
    /*  6: 18 - 19 */ true,false,
    /*  7: 20 - 21 */ true,false,
    /*  8:      22 */ false,
    /* Metoda BMA */
    /*  9: 23 - 24 */ true,false,
    /* 10:      25 */ false,
    /* 11: 26 - 27 */ false,false,
    /* 12: 28 - 33 */ false,true,true,false,false,false,
    /* 13: 34 - 40 */ true,false,true,false,false,false,false,
    /* 14: 41 - 43 */ false,false,false,
    /* 15: 44 - 45 */ false,false,
    /* 16: 46 - 51 */ false,true,true,false,false,false,
    /* 17: 52 - 58 */ true,false,true,false,false,false,false,
    /* 18: 59 - 61 */ false,false,false,
    /* 19:      62 */ false,
    /* 20: 63 - 64 */ false,false,
    /* 21: 65 - 66 */ false,false,
    /* 22:      67 */ false,
    /* 23: 68 - 72 */ true,false,false,false,false,
    /* 24: 73 - 75 */ true,false,false,
    /* 25: 76 - 77 */ false,false,
    /* 26: 78 - 81 */ true,false,false,false,
    /* 27:      82 */ false,
    /* 28: 83 - 89 */ true,false,false,false,false,false,false,
    /* 29: 90 - 91 */ false,false,
    /* 30: 92 - 96 */ true,false,false,false,false,
    /* 31:  97 - 101 */ true,false,false,false,false,
    /* 32: 102 - 104 */ true,false,false,
    /* 33: 105 - 107 */ false,false,false,
    /* 34: 108 - 112 */ true,false,false,false,false,
    /* 35:       113 */ false,
    /* 36: 114 - 115 */ false,false,
    /* 37:       116 */ false,
    /* 38:       117 */ false,
    /* 39: 118 - 121 */ true,false,false,false,
    /* 40: 122 - 123 */ false,false,
    /* 41:       124 */ false,
    /* Metoda pro výpočet delta1 */
    /* 42: 125 - 126 */ true,false,
    /* 43:       127 */ false,
    /* 44: 128 - 130 */ false,true,false,
    /* 45:       131 */ false,
    /* 46:       132 */ false,
    /* 47:       133 */ false,    
    /* 48: 134 - 140 */ true,false,true,false,false,false,false,
    /* 49:       141 */ false,
    /* 50:       142 */ false,
    /* 51:       143 */ false,
    /* 52: 144 - 145 */ false,false,
    /* 53:       146 */ false,
    /* Metoda pro výpočet delta2 */
    /* 54: 147 - 148 */ true,false,
    /* 55:       149 */ false,
    /* 56: 150 - 155 */ false,true,true,false,false,false,
    /* 57: 156 - 161 */ false,true,true,false,false,false,
    /* 58: 162 - 164 */ false,false,false,
    /* 59: 165 - 167 */ false,false,false,
    /* 60: 168 - 175 */ true,false,true,false,false,false,false,false,
    /* 61: 176 - 178 */ false,false,false,
    /* 62:       179 */ false,
    /* 63:       180 */ false,
    /* 64:       181 */ false,
    /* 65: 182 - 186 */ true,false,false,false,false,
    /* 66: 187 - 191 */ true,false,false,false,false,
    /* 67: 192 - 193 */ true,false,
    /* 68: 194 - 200 */ true,false,false,false,false,false,false,
    /* 69:       201 */ false,
    /* 70: 202 - 204 */ false,false,false,
    /* 71:       205 */ false,
    /* 72: 206 - 210 */ true,false,false,false,false,
    /* 73: 211 - 215 */ false,false,false,false,false,
    /* 74: 216 - 218 */ false,false,false,
    /* 75: 219 - 223 */ false,false,false,false,false,
    /* 76:       224 */ false,
    /* 77:       225 */ false,
    /* 78: 226 - 230 */ true,false,false,false,false,
    /* 79: 231 - 235 */ true,false,false,false,false,
    /* 80: 236 - 238 */ true,false,false,
    /* 81: 239 - 242 */ true,false,false,false,
    /* 82: 243 - 245 */ false,false,false,
    /* 83: 246 - 247 */ true,false,
    /* 84:       248 */ false,
    /* 85:       249 */ false,
    /* 86:       250 */ false,
    /* 87: 251 - 253 */ false,false,false,
    /* 88:       254 */ false,
    /* 89: 255 - 256 */ false,false
  };  // tucneCastiAlgoritmu
  
  
  /**
   * Pole se začátky a konci řádků algoritmu (pro zvýrazňování)
   */
  public static final int[][] radkyAlgoritmu = {
   /* Deklarace proměnných  */
   /*  0 */ {0,2},
   /*  1 */ {3,5},
   /*  2 */ {6,8},
   /*  3 */ {9,11},
   /*  4 */ {12,14},
   /*  5 */ {15,17},
   /*  6 */ {18,19},
   /*  7 */ {20,21},
   /*  8 */ {22,22},
   /* Metoda BMA */
   /*  9 */ {23,24},
   /* 10 */ {25,25},
   /* 11 */ {26,27},
   /* 12 */ {28,33},
   /* 13 */ {34,40},
   /* 14 */ {41,43},
   /* 15 */ {44,45},
   /* 16 */ {46,51},
   /* 17 */ {52,58},
   /* 18 */ {59,61},
   /* 19 */ {62,62},
   /* 20 */ {63,64},
   /* 21 */ {65,66},
   /* 22 */ {67,67},
   /* 23 */ {68,72},
   /* 24 */ {73,75},
   /* 25 */ {76,77},
   /* 26 */ {78,81},
   /* 27 */ {82,82},
   /* 28 */ {83,89},
   /* 29 */ {90,91},
   /* 30 */ {92,96},
   /* 31 */ {97,101},
   /* 32 */ {102,104},
   /* 33 */ {105,107},
   /* 34 */ {108,112},
   /* 35 */ {113,113},
   /* 36 */ {114,115},
   /* 37 */ {116,116},
   /* 38 */ {117,117},
   /* 39 */ {118,121},
   /* 40 */ {122,123},
   /* 41 */ {124,124},
   /* Metoda pro výpočet delta1 */
   /* 42 */ {125,126},
   /* 43 */ {127,127},
   /* 44 */ {128,130},
   /* 45 */ {131,131},
   /* 46 */ {132,132},
   /* 47 */ {133,133},
   /* 48 */ {134,140},
   /* 49 */ {141,141},
   /* 50 */ {142,142},
   /* 51 */ {143,143},
   /* 52 */ {144,145},
   /* 53 */ {146,146},
   /* Metoda pro výpočet delta2 */
   /* 54 */ {147,148},
   /* 55 */ {149,149},
   /* 56 */ {150,155},
   /* 57 */ {156,161},
   /* 58 */ {162,164},
   /* 59 */ {165,167},
   /* 60 */ {168,175},
   /* 61 */ {176,178},
   /* 62 */ {179,179},
   /* 63 */ {180,180},
   /* 64 */ {181,181},
   /* 65 */ {182,186},
   /* 66 */ {187,191},
   /* 67 */ {192,193},
   /* 68 */ {194,200},
   /* 69 */ {201,201},
   /* 70 */ {202,204},
   /* 71 */ {205,205},
   /* 72 */ {206,210},
   /* 73 */ {211,215},
   /* 74 */ {216,218},
   /* 75 */ {219,223},
   /* 76 */ {224,224},
   /* 77 */ {225,225},
   /* 78 */ {226,230},
   /* 79 */ {231,235},
   /* 80 */ {236,238},
   /* 81 */ {239,242},
   /* 82 */ {243,245},
   /* 83 */ {246,247},
   /* 84 */ {248,248},
   /* 85 */ {249,249},
   /* 86 */ {250,250},
   /* 87 */ {251,253},
   /* 88 */ {254,254},
   /* 89 */ {255,256}
  };  // radkyAlgoritmu
  
  /**
   * Pole se začátky a konci bloků algoritmu (pro vypisování)
   */
  public static final int[][] blokyAlgoritmu = {
    /* 0 */ {0,22},  // deklarace proměnných
    /* 1 */ {23,124},  // Metoda BMA
    /* 2 */ {125,146},  // Metoda pro výpočet delta1
    /* 3 */ {147,256},  // Metoda pro výpočet delta2
  };
  
  /** Názvy bloků zdrojového kódu BMA - blok s deklaracemi */
  public static final int BLOK_DEKLARACE = 0;
  /** Názvy bloků zdrojového kódu BMA - blok s algoritmem hledání řetězce */
  public static final int BLOK_BMA = 1;
  /** Názvy bloků zdrojového kódu BMA - blok s výpočtem tabulky delta1 */
  public static final int BLOK_DELTA1 = 2;
  /** Názvy bloků zdrojového kódu BMA - blok s výpočtem tabulky delta2 */
  public static final int BLOK_DELTA2 = 3;
  
  /**
   * Konstanta pro reprezentaci řádku mimo algoritmus (pro zvýrazňování)
   */
  public static final int ZADNY_RADEK = 900;
  
  /**
   * Řetězec pro záhlaví sloupce pro jiné znaky v tabulce delta1
   */
  public static final String JINE_ZNAKY = "jiné znaky";
  
  /**
   * Konstruktor třídy (třída obsahuje pouze konstanty, konstruktor je tedy 
   * prázdný)
   */
  public Konstanty() {
  }
  
}  // public class Konstanty

/*** Konec souboru Konstanty.java ***/
