/******************************************************************************
 * Název projektu: Applet pro demonstraci Boyerova-Mooreova algoritmu
 * Balíček: boyermooredemo
 * Soubor: AppletBoyerMooreDemo.java
 * Datum:  11.4.2008
 * Poslední změna: 18.4.2008
 * Autor:  Jaroslav Dytrych xdytry00
 *
 * Popis: Třída tvořící applet pro demonstraci Boyerova-Mooreova algoritmu
 *
 ******************************************************************************/

/**
 * @file AppletBoyerMooreDemo.java
 * 
 * @brief Třída AppletBoyerMooreDemo - appplet pro demonstraci BMA, základ projektu
 */

/**
 * @package boyermooredemo
 * 
 * @brief Applet pro demonstraci Boyerova-Mooreova algoritmu
 */

package boyermooredemo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import java.util.ArrayList;
import java.util.ListIterator;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

/**
 * Třída tvořící applet pro demonstraci Boyerova-Mooreova algoritmu
 * 
 * @brief Applet pro demonstraci BMA, základ projektu
 */
public class AppletBoyerMooreDemo extends JFrame {

  /**
   * Instance třídy s konstantami
   */
  public Konstanty kon = new Konstanty();  // třída s konstantami
  /**
   * Instance třídy s BMA
   */
  private Algoritmus algBMA = new Algoritmus(this);  // třída s BMA
  
  /** Aktuální krok vizualizace */
  private int aktKrok = 0;
  /** Celkový počet kroků vizualizace */
  public int pocetKroku = 0;
  /**
   * Kontejner pro informace o změnách uživatelského rozhraní při vizualizaci
   */
  public ArrayList<ZmenaZobrazeni> prubehViz = new ArrayList<ZmenaZobrazeni>();
  /**
   * Iterátor pro kontejner s informacemi o změnách uživatelského rozhraní 
   * při vizualizaci
   */
  public ListIterator iteratorViz;
  
  /** Číslo zobrazeného textu nápovědy */
  private int zobrazenaNapoveda = 0;
  
  /**
   * Číslo aktuálně zobrazeného bloku algoritmu, pokud je vypsáno více bloků, 
   * číslo prvního z nich
   */
  private int zobrazenyBlokAlgoritmu = 0;
  /** Číslo aktuálně zvýrazněného řádku algoritmu */
  private int zvyraznenyRadek = kon.ZADNY_RADEK;
  
  /** Popisek pro nadpis v hlavním panelu appletu */
  private JLabel jLabelNadpis = new JLabel();
  
  /** Popisek políčka pro hledaný řetězec */
  private JLabel jLabelHledanyRetezec = new JLabel();
  /** Políčko pro hledaný řetězec */
  private JTextField jTextFieldHledanyRetezec = new JTextField();
  
  /** Popisek textového pole pro prohledávaný text */
  private JLabel jLabelProhledavanyText = new JLabel();
  /** Textové pole pro prohledávaný text */
  private JTextArea jTextAreaProhledavanyText = new JTextArea();
  /** Skrolovací panel pro textové pole pro prohledávaný text */
  private JScrollPane jScrollPaneProhledavanyText = new JScrollPane();
  
  /** Popisek pro panel pro zobrazení zdrojového textu algoritmu */
  private JLabel jLabelAlgoritmus = new JLabel();
  /** Panel pro zobrazení zdrojového textu algoritmu */
  private BarevnyTextPane barevnyTextPaneAlgoritmus = new BarevnyTextPane();
  /** Skrolovací panel pro panel pro zobrazení zdrojového textu algoritmu */
  private JScrollPane jScrollPaneAlgoritmus = new JScrollPane();
  
  /** Tabulka s řetězci pro vizualizaci (zobrazuje porovnávání řetězců) */
  private Tabulka tabulkaSR = new Tabulka(kon.TAB_SR_VR[0],kon.TAB_SR_VR[1],
                                          0,2,new Color(255,255,255),
                                          new Color(0,0,0), false, false);
  /** Skrolovací panel pro tabulku s řetězci pro vizualizaci */
  private JScrollPane jScrollPaneTabulkaSR = new JScrollPane();
  
  /** Popisek tabulky delta1 */
  private JLabel jLabelTabulkaDelta1 = new JLabel();
  /** Tabulka delta1 */
  private Tabulka tabulkaDelta1 = new Tabulka(kon.TAB_D1_VR[0],kon.TAB_D1_VR[1],
                                              1,4,new Color(255,255,255),
                                              new Color(0,0,0), true, true);
  /** Skrolovací panel pro tabulku delta1 */
  private JScrollPane jScrollPaneTabulkaDelta1 = new JScrollPane();
  
  /** Popisek pro tabulku delta2 */
  private JLabel jLabelTabulkaDelta2 = new JLabel();  
  /** Tabulka delta2 (jsou v ní zobrazeny i pole pat a shoda) */
  private Tabulka tabulkaDelta2 = new Tabulka(kon.TAB_D2_VR[0],kon.TAB_D2_VR[1],
                                              1,4,new Color(255,255,255),
                                              new Color(0,0,0), true, false);
  /** Skrolovací panel pro tabulku delta2 */
  private JScrollPane jScrollPaneTabulkaDelta2 = new JScrollPane();
  
  /** Tlačítko "Zpět" */
  private JButton jButtonZpet = new JButton();
  /** Tlačítko "Vpřed" */
  private JButton jButtonVpred = new JButton();
  /** Tlačítko "Reset" */
  private JButton jButtonReset = new JButton();
  
  /** Popisek pro textové pole s nápovědou */
  private JLabel jLabelNapoveda = new JLabel();
  /** Textové pole s nápovědou */
  private JTextArea jTextAreaNapoveda = new JTextArea();
  /** Skrolovací panel pro textové pole s nápovědou */
  private JScrollPane jScrollPaneNapoveda = new JScrollPane();
  
  /** Popisek pro políčko s proměnnou m */
  private JLabel jLabelm = new JLabel();
  /** Políčko s proměnnou m */
  private JTextField jTextFieldm = new JTextField();
  
  /** Popisek pro políčko s proměnnou n */
  private JLabel jLabeln = new JLabel();
  /** Políčko s proměnnou n */
  private JTextField jTextFieldn = new JTextField();  
  
  /** Popisek pro políčko s proměnnou i */
  private JLabel jLabeli = new JLabel();
  /** Políčko s proměnnou i */
  private JTextField jTextFieldi = new JTextField(); 
  
  /** Popisek pro políčko s proměnnou j */
  private JLabel jLabelj = new JLabel();
  /** Políčko s proměnnou j */
  private JTextField jTextFieldj = new JTextField();
  
  /** Popisek pro políčko s proměnnou m-j+1 nebo n-m+1 */
  private JLabel jLabelmj = new JLabel();
  /** Políčko s proměnnou m-j+1 nebo n-m+1 */
  private JTextField jTextFieldmj = new JTextField();
  
  /** Popisek pro políčko s proměnnou i-j+1 nebo i+j-1 */
  private JLabel jLabelij = new JLabel();
  /** Políčko s proměnnou i-j+1 nebo i+j-1 */
  private JTextField jTextFieldij = new JTextField();
  
  /** Popisek pro políčko s proměnnou s */
  private JLabel jLabels = new JLabel();
  /** Políčko s proměnnou s */
  private JTextField jTextFields = new JTextField();
  
  /** Popisek pro políčko s proměnnou t */
  private JLabel jLabelt = new JLabel();
  /** Políčko s proměnnou t */
  private JTextField jTextFieldt = new JTextField();
  
  /** Popisek pro políčko s proměnnou L nebo d1P */
  private JLabel jLabelL = new JLabel();
  /** Políčko s proměnnou L nebo d1P */
  private JTextField jTextFieldL = new JTextField();
  
  /** Popisek pro políčko s proměnnou poz */
  private JLabel jLabelpoz = new JLabel();
  /** Políčko s proměnnou poz */
  private JTextField jTextFieldpoz = new JTextField();
  
  /** Popisek pro počítadlo kroků (přímo obsahuje počítadlo kroků) */
  private JLabel jLabelPocitadloKroku = new JLabel();
  
  /** Popisek pro legendu */
  private JLabel jLabelLegenda = new JLabel();
  /** 1. položka legendy (modrý obdélníček) */
  private JTextField jTextFieldLegendaZvyrazneny = new JTextField();  
  /** 1. položka legendy (zvýrazněný řádek algoritmu) */
  private JLabel jLabel1LegendaZvyrazneny = new JLabel();


  /**
   * Konstruktor třídy - upravená metoda pro inicializaci původního appletu
   */
  public AppletBoyerMooreDemo()
  {
    // vytvoříme JFrame
    super();
    this.addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent e) {
        System.exit(0);
      };
    });
    
    try {
      jbInit();  // inicializace oblasti appletu
    } catch (Exception e) {
      e.printStackTrace();
    }
    
    this.setVisible(true); // zobrazení JFrame
  }  // public AppletBoyerMooreDemo() 

  /**
   * Metoda pro spuštění appletu konvertovaného na samostatnou aplikaci
   */
  public static void main(String[] args) {
    AppletBoyerMooreDemo abmd = new AppletBoyerMooreDemo();
  }

  /**
   * Metoda pro inicializaci oblasti appletu
   *
   * @throws Exception Libovolná obecná programová výjimka při inicializaci
   */
  private void jbInit() throws Exception {
    // nastavení rozložení v panelu
    this.getContentPane().setLayout(null);
    // nastavení rozměrů a písma hlavního panelu appletu
    this.setSize(new Dimension(964, 720));
    this.setFont(new Font("Dialog", 1, 12));
    
    // nastavení jednotlivých komponent GUI (rozměry, umístění, texty popisků,  
    // barvy, tool-tipy, písma)
    jLabelNadpis.setText("Demonstrace Boyerova-Mooreova algoritmu");
    jLabelNadpis.setToolTipText("null");
    jLabelNadpis.setFont(new Font("Dialog", 1, 14));
    jLabelNadpis.setBounds(new Rectangle(20, 10, 385, 15));
    jLabelHledanyRetezec.setText("Hledaný řetězec:");
    jLabelHledanyRetezec.setBounds(new Rectangle(20, 35, 135, 20));
    jLabelHledanyRetezec.setLabelFor(jTextFieldHledanyRetezec);
    jTextFieldHledanyRetezec.setBounds(new Rectangle(140, 35, 305, 20));
    jLabelProhledavanyText.setText("Prohledávaný text:");
    jLabelProhledavanyText.setBounds(new Rectangle(20, 60, 140, 20));
    jScrollPaneProhledavanyText.setBounds(new Rectangle(20, 80, 425, 65));
    jTextAreaProhledavanyText.setColumns(20);
    jTextAreaProhledavanyText.setRows(4);
    jScrollPaneAlgoritmus.setBounds(new Rectangle(460, 25, 475, 610));
    jLabelAlgoritmus.setText("Algoritmus:");
    jLabelAlgoritmus.setBounds(new Rectangle(460, 5, 135, 20));
    jScrollPaneTabulkaSR.setBounds(new Rectangle(20, 155, 425, 65));
    jScrollPaneTabulkaDelta1.setBounds(new Rectangle(20, 245, 425, 75));
    jScrollPaneTabulkaDelta2.setBounds(new Rectangle(20, 345, 425, 120));
    jLabelTabulkaDelta1.setText("Tabulka delta1 (CharJump):");
    jLabelTabulkaDelta2.setText("Tabulka delta2 (MatchJump):");
    jLabelTabulkaDelta1.setBounds(new Rectangle(20, 225, 225, 20));
    jLabelTabulkaDelta2.setBounds(new Rectangle(20, 325, 225, 20));
    jButtonZpet.setText("Zpět");
    jButtonZpet.setBounds(new Rectangle(25, 525, 70, 25));
    jButtonVpred.setText("Vpřed");
    jButtonVpred.setBounds(new Rectangle(110, 525, 90, 25));

    jButtonReset.setText("Reset");
    jButtonReset.setBounds(new Rectangle(365, 525, 75, 25));
    jLabelNapoveda.setText("Nápověda:");
    jLabelNapoveda.setBounds(new Rectangle(25, 550, 75, 20));
    jScrollPaneNapoveda.setBounds(new Rectangle(25, 570, 420, 95));
    jLabelLegenda.setText("Legenda:");
    jLabelLegenda.setBounds(new Rectangle(465, 640, 80, 20));
    jLabelLegenda.setFont(new Font("Dialog", 1, 12));
    jLabeli.setText("i = ");
    jLabeli.setBounds(new Rectangle(100, 470, 25, 20));
    jLabelj.setBounds(new Rectangle(170, 470, 25, 20));
    jLabelj.setText("j = ");
    jTextFieldi.setBounds(new Rectangle(125, 470, 35, 20));
    jTextFieldi.setBackground(new Color(99, 255, 99));
    jTextFieldj.setBounds(new Rectangle(195, 470, 35, 20));
    jTextFieldj.setBackground(new Color(115, 255, 255));
    jLabelm.setText("m = ");
    jLabelm.setBounds(new Rectangle(25, 470, 40, 20));
    jLabelm.setToolTipText("Délka hledaného řetězce");
    jTextFieldm.setBounds(new Rectangle(55, 470, 35, 20));
    jTextFieldm.setToolTipText("Délka hledaného řetězce");
    jTextFieldm.setBackground(Color.white);
    jLabelmj.setText("m-j+1 = ");
    jLabelmj.setBounds(new Rectangle(332, 470, 65, 20));
    jTextFieldmj.setBounds(new Rectangle(395, 470, 35, 20));
    jTextFieldmj.setBackground(new Color(255, 165, 165));
    jLabelij.setText("i-j+1 = ");
    jLabelij.setBounds(new Rectangle(240, 470, 55, 20));
    jTextFieldij.setBounds(new Rectangle(290, 470, 35, 20));
    jTextFieldij.setBackground(new Color(255, 255, 66));
    jLabeln.setText("n = ");
    jLabeln.setBounds(new Rectangle(25, 495, 30, 20));
    jLabeln.setToolTipText("Délka prohledávaného textu");
    jTextFieldn.setBounds(new Rectangle(55, 495, 35, 20));
    jTextFieldn.setToolTipText("Délka prohledávaného textu");
    jTextFieldn.setBackground(Color.white);
    jLabels.setText("s = ");
    jLabels.setBounds(new Rectangle(100, 495, 25, 20));
    jTextFields.setBounds(new Rectangle(125, 495, 35, 20));
    jTextFields.setBackground(new Color(255, 165, 214));
    jLabelt.setText("t = ");
    jLabelt.setBounds(new Rectangle(170, 495, 25, 20));
    jTextFieldt.setBounds(new Rectangle(195, 495, 35, 20));
    jTextFieldt.setBackground(new Color(198, 198, 255));
    jLabelL.setText("     L = ");
    jLabelL.setBounds(new Rectangle(245, 495, 50, 20));
    jTextFieldL.setBounds(new Rectangle(290, 495, 35, 20));
    jTextFieldL.setBackground(new Color(255, 222, 214));
    jLabelpoz.setText("poz = ");
    jLabelpoz.setBounds(new Rectangle(350, 495, 45, 20));
    jLabelpoz.setToolTipText("Pozice hledaného řetězce v textu");
    jTextFieldpoz.setBounds(new Rectangle(395, 495, 35, 20));
    jTextFieldpoz.setBackground(new Color(255, 181, 99));
    jTextFieldpoz.setToolTipText("Pozice hledaného řetězce v textu");
    jLabelPocitadloKroku.setBounds(new Rectangle(210, 525, 115, 25));
    jLabelPocitadloKroku.setHorizontalAlignment(SwingConstants.CENTER);
    jLabelPocitadloKroku.setToolTipText("null");
    jLabel1LegendaZvyrazneny.setText("Zvýraznění naposledy provedeného řádku zdrojového kódu");
    jLabel1LegendaZvyrazneny.setBounds(new Rectangle(555, 640, 370, 20));
    jLabel1LegendaZvyrazneny.setFont(new Font("Dialog", 0, 10));
    jTextFieldLegendaZvyrazneny.setBounds(new Rectangle(535, 645, 15, 10));
    jTextFieldLegendaZvyrazneny.setBackground(kon.BARVA_ZVYRAZNENI_P);
    jTextFieldLegendaZvyrazneny.setEditable(false);

    // Přiřazení obsluhy událostí myši tlačítku "Vpřed"
    jButtonVpred.addMouseListener(new MouseAdapter() {
        public void mouseClicked(MouseEvent e) 
        {  // obsluha kliknutí myší
            jButtonVpred_mouseClicked(e);  // volání metody pro obsluhu
        }
      });
    // Přiřazení obsluhy událostí myši tlačítku "Zpět"
    jButtonZpet.addMouseListener(new MouseAdapter() {
        public void mouseClicked(MouseEvent e) 
        {  // obsluha kliknutí myší
          jButtonZpet_mouseClicked(e);  // volání metody pro obsluhu
        }
      });
    // Přiřazení obsluhy událostí myši tlačítku "Reset"
    jButtonReset.addMouseListener(new MouseAdapter() {
        public void mouseClicked(MouseEvent e) 
        {  // obsluha kliknutí myší
          jButtonReset_mouseClicked(e);  // volání metody pro obsluhu
        }
      });
        
    // nastaví výchozí šířku buňky tabulek na šířku písmene A
    tabulkaSR.nastavObsah(0,1,"A");
    tabulkaSR.nastavObsah(0,1,"");
    tabulkaDelta1.nastavObsah(0,1,"A");
    tabulkaDelta1.nastavObsah(0,1,"");
    tabulkaDelta2.nastavObsah(0,1,"A");
    tabulkaDelta2.nastavObsah(0,1,"");
    
    // vloží texty záhlaví do řádků
    tabulkaDelta1.nastavObsah(0,0,"c");
    tabulkaDelta1.nastavObsah(1,0,"delta1[c]");
    tabulkaDelta2.nastavObsah(0,0,"i");
    tabulkaDelta2.nastavObsah(1,0,"pat[i]");
    tabulkaDelta2.nastavObsah(2,0,"shoda[i]");
    tabulkaDelta2.nastavObsah(3,0,"delta2[i]");
    
    // zakázání modifikace panelu s algoritmem
    barevnyTextPaneAlgoritmus.setEditable(false);
    
    // výpis kompletního zdrojového kódu algoritmu
    vypisAlgoritmus();
    
    // zakázání modifikace nápovědy
    jTextAreaNapoveda.setEditable(false);
    
    // vloží do pole s nápovědou výchozí obsah
    jTextAreaNapoveda.setText(kon.textyNapovedy[0]);
    zobrazenaNapoveda = 0;
    
    // zakázání modifikace políček s proměnnými
    jTextFieldm.setEditable(false);
    jTextFieldn.setEditable(false);
    jTextFieldi.setEditable(false);
    jTextFieldj.setEditable(false);
    jTextFieldij.setEditable(false);
    jTextFieldmj.setEditable(false);
    jTextFields.setEditable(false);
    jTextFieldt.setEditable(false);
    jTextFieldL.setEditable(false);
    jTextFieldpoz.setEditable(false);
    
    // okraje políček s proměnnými
    jTextFieldm.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldn.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldi.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldj.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldij.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldmj.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFields.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldt.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldL.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));
    jTextFieldpoz.setBorder(BorderFactory.createLineBorder(new Color(148,148,148), 1));


    // vloží prvky do jejich skrolovacích panelů
    jScrollPaneTabulkaSR.setViewportView(tabulkaSR);
    jScrollPaneTabulkaDelta1.setViewportView(tabulkaDelta1);
    jScrollPaneTabulkaDelta2.setViewportView(tabulkaDelta2);
    jScrollPaneAlgoritmus.setViewportView(barevnyTextPaneAlgoritmus);
    jScrollPaneNapoveda.setViewportView(jTextAreaNapoveda);
    jScrollPaneProhledavanyText.setViewportView(jTextAreaProhledavanyText);
    
    // vložení komponent GUI do panelu s appletem
    this.getContentPane().add(jTextFieldLegendaZvyrazneny, null);
    this.getContentPane().add(jLabel1LegendaZvyrazneny, null);
    this.getContentPane().add(jLabelPocitadloKroku, null);
    this.getContentPane().add(jTextFieldpoz, null);
    this.getContentPane().add(jLabelpoz, null);
    this.getContentPane().add(jTextFieldL, null);
    this.getContentPane().add(jLabelL, null);
    this.getContentPane().add(jTextFieldt, null);
    this.getContentPane().add(jLabelt, null);
    this.getContentPane().add(jTextFields, null);
    this.getContentPane().add(jLabels, null);
    this.getContentPane().add(jTextFieldn, null);
    this.getContentPane().add(jLabeln, null);
    this.getContentPane().add(jTextFieldij, null);
    this.getContentPane().add(jLabelij, null);
    this.getContentPane().add(jTextFieldmj, null);
    this.getContentPane().add(jLabelmj, null);
    this.getContentPane().add(jTextFieldm, null);
    this.getContentPane().add(jLabelm, null);
    this.getContentPane().add(jTextFieldj, null);
    this.getContentPane().add(jTextFieldi, null);
    this.getContentPane().add(jLabelj, null);
    this.getContentPane().add(jLabeli, null);
    this.getContentPane().add(jLabelLegenda, null);
    this.getContentPane().add(jScrollPaneNapoveda, null);
    this.getContentPane().add(jLabelNapoveda, null);
    this.getContentPane().add(jButtonReset, null);
    this.getContentPane().add(jButtonVpred, null);
    this.getContentPane().add(jButtonZpet, null);
    this.getContentPane().add(jLabelTabulkaDelta1, null);
    this.getContentPane().add(jLabelTabulkaDelta2, null);
    this.getContentPane().add(jScrollPaneTabulkaSR, null);
    this.getContentPane().add(jLabelAlgoritmus, null);
    this.getContentPane().add(jScrollPaneAlgoritmus, null);
    this.getContentPane().add(jScrollPaneProhledavanyText, null);
    this.getContentPane().add(jLabelProhledavanyText, null);
    this.getContentPane().add(jTextFieldHledanyRetezec, null);
    this.getContentPane().add(jLabelHledanyRetezec, null);
    this.getContentPane().add(jLabelNadpis);
    this.getContentPane().add(jScrollPaneTabulkaDelta1, null);
    this.getContentPane().add(jScrollPaneTabulkaDelta2, null);
    
    // deaktivace tlačítka zpět
    jButtonZpet.setEnabled(false);
  }  // private void jbInit()

  /**
   * Metoda pro obsluhu kliknutí na tlačítko Vpřed
   *
   * @param e Událost myši
   */
  private void jButtonVpred_mouseClicked(MouseEvent e) {
    if (e.getButton()==e.BUTTON1 && ((Component)e.getSource()).isEnabled()) 
    {  // pokud se jedná o levé tlačítko myši a tlačítko Vpřed není zakázané
      if (aktKrok == 0)
      {  // pokud zatím vizualizace nezačala
        if (jTextFieldHledanyRetezec.getText().length() < 1)
        {  // pokud nebyl zadán hledaný řetězec
          JOptionPane.showMessageDialog(this, "Nebyl zadán hledaný řetězec",
                                        "Chyba",JOptionPane.ERROR_MESSAGE);
          return;
        }
        if (jTextAreaProhledavanyText.getText().length() < 1)
        {  // pokud nebyl zadán prohledávaný text
          JOptionPane.showMessageDialog(this, "Nebyl zadán prohledávaný text",
                                        "Chyba",JOptionPane.ERROR_MESSAGE);
          return;
        }
        
        // zakáže editaci řetězců
        jTextFieldHledanyRetezec.setEditable(false);
        jTextAreaProhledavanyText.setEditable(false);
        
        // přejde na 1. krok vizualizace
        aktKrok = 1;
        // počet kroků vizualizace je nyní 1
        pocetKroku = 1;
        
        // Provede hledání řetězce pomocí BMA a vytvoří seznam změn zobrazení, 
        // se kterým bude následně prováděna vizualizace.
        // Nastaví také počet kroků.
        algBMA.BMA(jTextFieldHledanyRetezec.getText(),jTextAreaProhledavanyText.getText());
        // získá iterátor do kontejneru se změnami zobrazení
        iteratorViz = prubehViz.listIterator();
        
        // vypíše obsah políčka s počítadlem kroků
        jLabelPocitadloKroku.setText("krok 1 z " + pocetKroku);
        
        // nastaví 2. text nápovědy
        zobrazenaNapoveda = 1;
        jTextAreaNapoveda.setText(kon.textyNapovedy[zobrazenaNapoveda]);
        
        // vloží do pole s algoritmem metodu BMA
        this.vypisBlokAlgoritmu(kon.BLOK_BMA,true);
        // zvýrazní 1. řádek (9. řádek zdrojového kódu)
        this.zvyrazniRadek(9);
      }  // pokud zatím vizualizace nezačala
      else
      {  // pokud již vizualizace probíhá
        if (aktKrok < pocetKroku)
        {  // pokud lze udělat krok vpřed
          krokVpred();  // udělá krok vpřed
        
          if (aktKrok >= pocetKroku)
          {  // pokud již nebude možné udělat další krok vpřed
            jButtonVpred.setEnabled(false);  // zakáže tlačítko Vpřed
          }
          // byl udělán krok vpřed a následně tedy bude možné i zpět
          jButtonZpet.setEnabled(true);  // povolí tlačítko Zpět
        }  // pokud lze udělat krok vpřed
        else
        {  // pokud nelze udělat krok vpřed
          jButtonVpred.setEnabled(false);  // zakáže tlačítko Vpřed
        }
      }  // pokud již vizualizace probíhá
    }  // pokud se jedná o levé tlačítko myši a tlačítko Vpřed není zakázané
  }  // private void jButtonVpred_mouseClicked()
  
  /**
   * Metoda pro obsluhu kliknutí na tlačítko Zpět
   *
   * @param e Událost myši
   */
  private void jButtonZpet_mouseClicked(MouseEvent e) {
    if (e.getButton()==e.BUTTON1 && ((Component)e.getSource()).isEnabled()) 
    {  // pokud se jedná o levé tlačítko myši a tlačítko Zpět není zakázané
      if (aktKrok > 1)  
      {  // pokud lze udělat krok zpět
        krokZpet();  // udělá krok zpět
        
        if (aktKrok <= 1)
        {  // pokud již nebude možné udělat další krok zpět
          jButtonZpet.setEnabled(false);// zakáže tlačítko Zpět
        }
        // byl udělán krok zpět a následně tedy bude možné i Vpřed
        jButtonVpred.setEnabled(true);  // povolí tlačítko Vpřed
      }  // pokud lze udělat krok zpět
      else
      {  // pokud nelze udělat krok zpět
        jButtonZpet.setEnabled(false);// zakáže tlačítko Zpět
      }
    }  // pokud se jedná o levé tlačítko myši a tlačítko Zpět není zakázané
  }  // private void jButtonZpet_mouseClicked()
   
  /**
   * Metoda pro obsluhu kliknutí na tlačítko Reset
   *
   * @param e Událost myši
   */
  private void jButtonReset_mouseClicked(MouseEvent e) {
    if (e.getButton()==e.BUTTON1 && ((Component)e.getSource()).isEnabled()) 
    {  // pokud se jedná o levé tlačítko myši a tlačítko Reset není zakázané
      // zakáže tlačítko Zpět a povolí tlačítko Vpřed
      jButtonZpet.setEnabled(false);
      jButtonVpred.setEnabled(true);
      // vynuluje počítadla kroků
      this.pocetKroku = 0;
      this.aktKrok = 0;
      this.jLabelPocitadloKroku.setText("");
      // vymaže obsah kontejneru se změnami
      this.prubehViz = new ArrayList<ZmenaZobrazeni>();
      // nastaví výchozí rozměry tabulek
      tabulkaSR.zmenRozmery(kon.TAB_SR_VR[0],kon.TAB_SR_VR[1]);
      tabulkaDelta1.zmenRozmery(kon.TAB_D1_VR[0],kon.TAB_D1_VR[1]);
      tabulkaDelta2.zmenRozmery(kon.TAB_D2_VR[0],kon.TAB_D2_VR[1]);
      // vymaže obsah tabulek
      tabulkaSR.vyprazdniTabulku(true);
      tabulkaDelta1.vyprazdniTabulku(false);
      tabulkaDelta2.vyprazdniTabulku(false);
      // nastaví výchozí šířku buňky tabulky na šířku písmene A
      tabulkaSR.nastavObsah(0,1,"A");
      tabulkaSR.nastavObsah(0,1,"");
      tabulkaDelta1.nastavObsah(0,1,"A");
      tabulkaDelta1.nastavObsah(0,1,"");
      tabulkaDelta2.nastavObsah(0,1,"A");
      tabulkaDelta2.nastavObsah(0,1,"");
      // vloží do pole s nápovědou výchozí obsah
      jTextAreaNapoveda.setText(kon.textyNapovedy[0]);
      zobrazenaNapoveda = 0;
      // vyprázdní pole s algoritmem a vloží do něj celý algoritmus
      barevnyTextPaneAlgoritmus.vyprazdniPanel();
      vypisAlgoritmus();
      // nyní není zvýrazněný žádný řádek
      zvyraznenyRadek = kon.ZADNY_RADEK;
      // nastaví popiskům výchozí texty
      jLabelij.setText(kon.TEXTY_POPISKU_IMJ);
      jLabelmj.setText(kon.TEXTY_POPISKU_MJ);
      jLabelL.setText(kon.TEXTY_POPISKU_L);
      // vymaže obsah polí s proměnnými
      jTextFieldm.setText("");
      jTextFieldn.setText("");
      jTextFieldi.setText("");
      jTextFieldj.setText("");
      jTextFieldij.setText("");
      jTextFieldmj.setText("");
      jTextFields.setText("");
      jTextFieldt.setText("");
      jTextFieldL.setText("");
      jTextFieldpoz.setText("");
      // povolí editaci řetězců
      jTextFieldHledanyRetezec.setEditable(true);
      jTextAreaProhledavanyText.setEditable(true);
    }  // pokud se jedná o levé tlačítko myši a tlačítko Reset není zakázané
  }  // private void jButtonReset_mouseClicked()
    
  /**
   * Metoda pro výpis celého algoritmu do textového pole s algoritmem
   */  
  private void vypisAlgoritmus()
  {
    // výpis jednotlivých bloků algoritmu
    vypisBlokAlgoritmu(kon.BLOK_DEKLARACE,false);
    vypisBlokAlgoritmu(kon.BLOK_BMA,false);
    vypisBlokAlgoritmu(kon.BLOK_DELTA1,false);
    vypisBlokAlgoritmu(kon.BLOK_DELTA2,false);
    this.zobrazenyBlokAlgoritmu = 0;  // jsou vypsány všechny bloky počínaje 0
  }
    
  /**
   * Metoda pro výpis bloku algoritmu do textového pole s algoritmem
   * 
   * @param cislo Číslo bloku, který se má vypsat
   * @param vymazat Určuje, zda se má před výpisem vymazat obsah pole
   */
  private void vypisBlokAlgoritmu(int cislo, boolean vymazat)
  {
    if (vymazat)
    {  // pokud se má vymazat obsah pole, vymaže jej
      barevnyTextPaneAlgoritmus.vyprazdniPanel();
    }
    for (int i = kon.blokyAlgoritmu[cislo][0]; i <= kon.blokyAlgoritmu[cislo][1]; i++)
    {  // výpis bloku po jednotlivých úsecích
      barevnyTextPaneAlgoritmus.pridejText(kon.textyAlgoritmu[i],kon.barvyAlgoritmu[i],
                                           new Color(255,255,255),
                                           kon.tucneCastiAlgoritmu[i]);
    }
    this.zobrazenyBlokAlgoritmu = cislo;  // aktualizace čísla zobrazeného bloku
  }
    
  /**
   * Metoda pro zvýraznění řádku algoritmu
   * 
   * @param cislo Číslo řádku algoritmu, který se má zvýraznit
   */
  private void zvyrazniRadek(int cislo)
  {
    int zacatek;  // pomocné proměnné
    int konec;
    if (zvyraznenyRadek != kon.ZADNY_RADEK)
    {  // pokud je zvýrazněný nějaký řádek
      // výpočet čísel bloků v panelu
      zacatek = kon.radkyAlgoritmu[zvyraznenyRadek][0] - kon.blokyAlgoritmu[zobrazenyBlokAlgoritmu][0];
      konec = kon.radkyAlgoritmu[zvyraznenyRadek][1] - kon.blokyAlgoritmu[zobrazenyBlokAlgoritmu][0];
      for (int i = zacatek; i <= konec; i++)
      {  // zruší zvýraznění jednotlivých bloků v řádku
        this.barevnyTextPaneAlgoritmus.nastavVychoziBarvu(i);;
      }
    }
    if (cislo != kon.ZADNY_RADEK)
    {  // pokud se má zvýraznit některý řádek
       // výpočet čísel bloků v panelu
        zacatek = kon.radkyAlgoritmu[cislo][0] - kon.blokyAlgoritmu[zobrazenyBlokAlgoritmu][0];
        konec = kon.radkyAlgoritmu[cislo][1] - kon.blokyAlgoritmu[zobrazenyBlokAlgoritmu][0];
      for (int i = zacatek; i <= konec; i++)
      {  // zvýrazní jednotlivé bloky v řádku
        this.barevnyTextPaneAlgoritmus.nastavBarvu(i,kon.BARVA_ZVYRAZNENI_T,kon.BARVA_ZVYRAZNENI_P);
      }
    }
    zvyraznenyRadek = cislo;  // aktualizace čísla zvýrazněného řádku
  }  // private void zvyrazniRadek()
   
  /**
   * Metoda pro nastavení hodnoty v políčku s proměnnou
   *
   * @param cislo Číslo políčka (definované ve třídě Konstanty)
   * @param hodnota Hodnota, která se má nastavit
   */
  private void nastavPolePromenne(int cislo,int hodnota)
  {
    Integer pomI;
    pomI = Integer.valueOf(hodnota);  // převede hodnotu na objekt
    // převede hodnotu na řetězec a volá metodu pro nastavení řetězcové hodnoty 
    // políčka
    nastavPolePromenne(cislo,pomI.toString());
  }  // private void nastavPolePromenne()
   
  /**
   * Metoda pro nastavení hodnoty v políčku s proměnnou
   *
   * @param cislo Číslo políčka (definované ve třídě Konstanty)
   * @param hodnota Hodnota, která se má nastavit
   */
  private void nastavPolePromenne(int cislo,String hodnota)
  {
    // zvolí správné pole a nastaví jeho hodnotu
    if (cislo == kon.PROM_M)
    {
      this.jTextFieldm.setText(hodnota);
    }
    else if (cislo == kon.PROM_N)
    {
      this.jTextFieldn.setText(hodnota);
    }
    else if (cislo == kon.PROM_I)
    {
      this.jTextFieldi.setText(hodnota);
    }
    else if (cislo == kon.PROM_J)
    {
      this.jTextFieldj.setText(hodnota);
    }
    else if (cislo == kon.PROM_IJ)
    {
      this.jTextFieldij.setText(hodnota);
    }
    else if (cislo == kon.PROM_MJ)
    {
      this.jTextFieldmj.setText(hodnota);
    }
    else if (cislo == kon.PROM_S)
    {
      this.jTextFields.setText(hodnota);
    }
    else if (cislo == kon.PROM_T)
    {
      this.jTextFieldt.setText(hodnota);
    }
    else if (cislo == kon.PROM_L)
    {
      this.jTextFieldL.setText(hodnota);
    }
    else if (cislo == kon.PROM_POZ)
    {
      this.jTextFieldpoz.setText(hodnota);
    }
  }  // private void nastavPolePromenne()
   
  /**
   * Metoda pro získání obsahu políčka s proměnnou
   *
   * @param cislo Číslo políčka (definované ve třídě Konstanty)
   * @return Vrací obsah políčka
   */
  private String vratObsahPolePromenne(int cislo)
  {
    // zvolí správné pole a vrátí jeho obsah
    if (cislo == kon.PROM_M)
    {
      return jTextFieldm.getText();
    }
    else if (cislo == kon.PROM_N)
    {
      return jTextFieldn.getText();
    }
    else if (cislo == kon.PROM_I)
    {
      return jTextFieldi.getText();
    }
    else if (cislo == kon.PROM_J)
    {
      return jTextFieldj.getText();
    }
    else if (cislo == kon.PROM_IJ)
    {
      return jTextFieldij.getText();
    }
    else if (cislo == kon.PROM_MJ)
    {
      return jTextFieldmj.getText();
    }
    else if (cislo == kon.PROM_S)
    {
      return jTextFields.getText();
    }
    else if (cislo == kon.PROM_T)
    {
      return jTextFieldt.getText();
    }
    else if (cislo == kon.PROM_L)
    {
      return jTextFieldL.getText();
    }
    else if (cislo == kon.PROM_POZ)
    {
      return jTextFieldpoz.getText();
    }
    return "";  // pokud nebylo zvoleno žádné pole, vrátí prázdný řetězec
  }  // private void vratHodnotuPolePromenne()
   
  /**
   * Metoda pro provedení jednoho kroku vizualizace
   */
  private void krokVpred() 
  {
    ZmenaZobrazeni zmena;  // proměnná pro informace o změně
    boolean konec = false;  // pomocná proměnná
    
    aktKrok++;  // provádí se krok vpřed
    
    // aktualizuje obsah políčka s počítadlem kroků
    jLabelPocitadloKroku.setText("krok " + aktKrok + " / " + pocetKroku);

    if (!iteratorViz.hasNext())
    {  // pokud není v seznamu žádná změna, nelze pokračovat
      return;
    }
    
    // získání informací o první změně v kroku
    zmena = (ZmenaZobrazeni)iteratorViz.next();
    
    while (!konec && zmena.cisloKroku == aktKrok)
    {  // provedení všech změn v kroku          
      if (zmena.operace == kon.ZM_T_H)
      {  // změna hodnoty políčka v tabulce
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          // nastaví původní hodnotu do objektu změny a provede změnu
          zmena.puvodniObsah = tabulkaSR.vratObsah(zmena.radek,zmena.sloupec);
          tabulkaSR.nastavObsah(zmena.radek,zmena.sloupec,zmena.novyObsah);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          // nastaví původní hodnotu do objektu změny a provede změnu
          zmena.puvodniObsah = tabulkaDelta1.vratObsah(zmena.radek,zmena.sloupec);
          tabulkaDelta1.nastavObsah(zmena.radek,zmena.sloupec,zmena.novyObsah);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          // nastaví původní hodnotu do objektu změny a provede změnu
          zmena.puvodniObsah = tabulkaDelta2.vratObsah(zmena.radek,zmena.sloupec);
          tabulkaDelta2.nastavObsah(zmena.radek,zmena.sloupec,zmena.novyObsah);
        }
      }  // změna hodnoty políčka v tabulce
      else if (zmena.operace == kon.ZM_T_B)
      {  // změna barvy políčka v tabulce
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          // nastaví původní hodnoty do objektu změny a provede změnu
          zmena.puvodniBarvaTextu = tabulkaSR.vratBarvu(zmena.radek,zmena.sloupec,0);
          zmena.puvodniBarvaPozadi = tabulkaSR.vratBarvu(zmena.radek,zmena.sloupec,1);
          tabulkaSR.nastavBarvu(zmena.radek,zmena.sloupec,zmena.barvaPozadi,
                                zmena.barvaTextu);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          // nastaví původní hodnoty do objektu změny a provede změnu
          zmena.puvodniBarvaTextu = tabulkaDelta1.vratBarvu(zmena.radek,zmena.sloupec,0);
          zmena.puvodniBarvaPozadi = tabulkaDelta1.vratBarvu(zmena.radek,zmena.sloupec,1);
          tabulkaDelta1.nastavBarvu(zmena.radek,zmena.sloupec,zmena.barvaPozadi,
                                    zmena.barvaTextu);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          // nastaví původní hodnoty do objektu změny a provede změnu
          zmena.puvodniBarvaTextu = tabulkaDelta2.vratBarvu(zmena.radek,zmena.sloupec,0);
          zmena.puvodniBarvaPozadi = tabulkaDelta2.vratBarvu(zmena.radek,zmena.sloupec,1);
          tabulkaDelta2.nastavBarvu(zmena.radek,zmena.sloupec,zmena.barvaPozadi,
                                    zmena.barvaTextu);
        }
      }  // změna barvy políčka v tabulce
      else if (zmena.operace == kon.ZM_T_P)
      {  // posun řádku tabulky
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          // posuv řádku
          tabulkaSR.posunRadek(zmena.radek,zmena.smer,zmena.pocet);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          // posuv řádku
          tabulkaDelta1.posunRadek(zmena.radek,zmena.smer,zmena.pocet);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          // posuv řádku
          tabulkaDelta2.posunRadek(zmena.radek,zmena.smer,zmena.pocet);
        }
      }  // posun řádku tabulky
      else if (zmena.operace == kon.ZM_T_R)
      {  // změna rozměrů tabulky
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          // nastaví původní rozměry do objektu změny a provede změnu
          zmena.puvodneRadku = tabulkaSR.vratPocetRadkuTabulky();
          zmena.puvodneSloupcu = tabulkaSR.vratPocetSloupcuTabulky();
          tabulkaSR.zmenRozmery(zmena.radek,zmena.sloupec);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          // nastaví původní rozměry do objektu změny a provede změnu
          zmena.puvodneRadku = tabulkaDelta1.vratPocetRadkuTabulky();
          zmena.puvodneSloupcu = tabulkaDelta1.vratPocetSloupcuTabulky();
          tabulkaDelta1.zmenRozmery(zmena.radek,zmena.sloupec);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          // nastaví původní rozměry do objektu změny a provede změnu
          zmena.puvodneRadku = tabulkaDelta2.vratPocetRadkuTabulky();
          zmena.puvodneSloupcu = tabulkaDelta2.vratPocetSloupcuTabulky();
          tabulkaDelta2.zmenRozmery(zmena.radek,zmena.sloupec);
        }
      }  // změna rozměrů tabulky
      else if (zmena.operace == kon.ZM_A_B)
      {  // výměna bloku v panelu s algoritmem
        // uloží číslo původního bloku do objektu změny a provede výměnu
        zmena.puvodniCislo = zobrazenyBlokAlgoritmu;
        vypisBlokAlgoritmu(zmena.cislo,true);
      }  // výměna bloku v panelu s algoritmem
      else if (zmena.operace == kon.ZM_A_Z)
      {  // změna zvýrazněného řádku v poli s algoritmem
        // uloží číslo zvýrazněného řádku do objektu změny a provede změnu
        zmena.puvodniCislo = zvyraznenyRadek;
        zvyrazniRadek(zmena.cislo);
      }  // změna zvýrazněného řádku v poli s algoritmem
      else if (zmena.operace == kon.ZM_P)
      {  // změna hodnoty proměnné
        // uloží původní hodnotu proměnné do objektu změny a provede změnu
        zmena.puvodniObsah = vratObsahPolePromenne(zmena.cislo);
        nastavPolePromenne(zmena.cislo,zmena.novyObsah);
      }  // změna hodnoty proměnné
      else if (zmena.operace == kon.ZM_N)
      {  // změna obsahu pole s nápovědou
        // uloží číslo zobrazeného textu do objektu změny a provede změnu
        zmena.puvodniCislo = zobrazenaNapoveda;
        zobrazenaNapoveda = zmena.cislo;
        jTextAreaNapoveda.setText(kon.textyNapovedy[zmena.cislo]);
      }  // změna obsahu pole s nápovědou
      else if (zmena.operace == kon.ZM_PO)
      {  // změna textu popisku
        if (zmena.cislo == kon.POPISEK_IJ)
        {  // pokud se jedná o popisek i-j+1 nebo i+j-1
          // uloží původní text popisku do objektu změny a provede změnu
          zmena.puvodniObsah = jLabelij.getText();
          jLabelij.setText(zmena.novyObsah);
        }
        else if (zmena.cislo == kon.POPISEK_MJ)
        {  // pokud se jedná o popisek m-j+1 nebo n-m+1
          // uloží původní text popisku do objektu změny a provede změnu
          zmena.puvodniObsah = jLabelmj.getText();
          jLabelmj.setText(zmena.novyObsah);
        }
        else if (zmena.cislo == kon.POPISEK_L)
        {  // pokud se jedná o popisek L nebo d1p
          // uloží původní text popisku do objektu změny a provede změnu
          zmena.puvodniObsah = jLabelL.getText();
          jLabelL.setText(zmena.novyObsah);
        }
      }  // změna textu popisku
      
      if (iteratorViz.hasNext())
      {  // pokud je k dispozici další změna
        // získání informací o další změně
        zmena = (ZmenaZobrazeni)iteratorViz.next();
      }
      else
      {  // pokud další změna není k dispozici
        konec = true;  // ukončí cyklus
      }
    }  // provedení všech změn v kroku
    
    if (zmena.cisloKroku != aktKrok)
    {  // přejel na 1. změnu dalšího kroku, je nutno se vrátit
      zmena = (ZmenaZobrazeni)iteratorViz.previous();  // návrat o 1 položku zpět
    }
  }  // krokVpred()
   
  /**
   * Metoda pro provedení jednoho zpětného kroku vizualizace
   */
  private void krokZpet()
  {
    ZmenaZobrazeni zmena;  // proměnná pro informace o změně
    boolean konec = false;  // pomocná proměnná
        
    if (!iteratorViz.hasPrevious())
    {  // pokud není v seznamu žádná změna k vrácení, nelze pokračovat
      return;
    }
    
    // získání informací o poslední změně v předchozím kroku
    zmena = (ZmenaZobrazeni)iteratorViz.previous();

    while (!konec && zmena.cisloKroku == aktKrok)
    {  // vrácení všech změn v kroku          
      if (zmena.operace == kon.ZM_T_H)
      {  // změna hodnoty políčka v tabulce
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          tabulkaSR.nastavObsah(zmena.radek,zmena.sloupec,zmena.puvodniObsah);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          tabulkaDelta1.nastavObsah(zmena.radek,zmena.sloupec,zmena.puvodniObsah);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          tabulkaDelta2.nastavObsah(zmena.radek,zmena.sloupec,zmena.puvodniObsah);
        }
      }  // změna hodnoty políčka v tabulce
      else if (zmena.operace == kon.ZM_T_B)
      {  // změna barvy políčka v tabulce
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          tabulkaSR.nastavBarvu(zmena.radek,zmena.sloupec,zmena.puvodniBarvaPozadi,
                                zmena.puvodniBarvaTextu);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          tabulkaDelta1.nastavBarvu(zmena.radek,zmena.sloupec,zmena.puvodniBarvaPozadi,
                                    zmena.puvodniBarvaTextu);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          tabulkaDelta2.nastavBarvu(zmena.radek,zmena.sloupec,zmena.puvodniBarvaPozadi,
                                    zmena.puvodniBarvaTextu);
        }
      }  // změna barvy políčka v tabulce
      else if (zmena.operace == kon.ZM_T_P)
      {  // posun řádku tabulky
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          if (zmena.smer == tabulkaSR.POSUN_VPRAVO)
          {  // pokud se posouvalo vpravo, posune vlevo
            tabulkaSR.posunRadek(zmena.radek,tabulkaSR.POSUN_VLEVO,zmena.pocet);
          }
          else
          {  // pokud se posouvalo vlevo, posune vpravo
            tabulkaSR.posunRadek(zmena.radek,tabulkaSR.POSUN_VPRAVO,zmena.pocet);
          }
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          if (zmena.smer == tabulkaDelta1.POSUN_VPRAVO)
          {  // pokud se posouvalo vpravo, posune vlevo
            tabulkaDelta1.posunRadek(zmena.radek,tabulkaDelta1.POSUN_VLEVO,zmena.pocet);
          }
          else
          {  // pokud se posouvalo vlevo, posune vpravo
            tabulkaDelta1.posunRadek(zmena.radek,tabulkaDelta1.POSUN_VPRAVO,zmena.pocet);
          }
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          if (zmena.smer == tabulkaDelta2.POSUN_VPRAVO)
          {  // pokud se posouvalo vpravo, posune vlevo
            tabulkaDelta2.posunRadek(zmena.radek,tabulkaDelta2.POSUN_VLEVO,zmena.pocet);
          }
          else
          {  // pokud se posouvalo vlevo, posune vpravo
            tabulkaDelta2.posunRadek(zmena.radek,tabulkaDelta2.POSUN_VPRAVO,zmena.pocet);
          }
        }
      }  // posun řádku tabulky
      else if (zmena.operace == kon.ZM_T_R)
      {  // změna rozměrů tabulky
        if (zmena.tabulka == kon.TAB_SR)
        {  // tabulkaSR
          tabulkaSR.zmenRozmery(zmena.puvodneRadku,zmena.puvodneSloupcu);
        }
        else if (zmena.tabulka == kon.TAB_D1)
        {  // tabulka delta1
          tabulkaDelta1.zmenRozmery(zmena.puvodneRadku,zmena.puvodneSloupcu);
        }
        else if (zmena.tabulka == kon.TAB_D2)
        {  // tabulka delta2
          tabulkaDelta2.zmenRozmery(zmena.puvodneRadku,zmena.puvodneSloupcu);
        }
      }  // změna rozměrů tabulky
      else if (zmena.operace == kon.ZM_A_B)
      {  // výměna bloku v panelu s algoritmem
        vypisBlokAlgoritmu(zmena.puvodniCislo,true);
      }  // výměna bloku v panelu s algoritmem
      else if (zmena.operace == kon.ZM_A_Z)
      {  // změna zvýrazněného řádku v poli s algoritmem
        zvyrazniRadek(zmena.puvodniCislo);
      }  // změna zvýrazněného řádku v poli s algoritmem
      else if (zmena.operace == kon.ZM_P)
      {  // změna hodnoty proměnné
        nastavPolePromenne(zmena.cislo,zmena.puvodniObsah);
      }  // změna hodnoty proměnné
      else if (zmena.operace == kon.ZM_N)
      {  // změna obsahu pole s nápovědou
        zobrazenaNapoveda = zmena.puvodniCislo;
        jTextAreaNapoveda.setText(kon.textyNapovedy[zmena.puvodniCislo]);
      }  // změna obsahu pole s nápovědou
      else if (zmena.operace == kon.ZM_PO)
      {  // změna textu popisku
        if (zmena.cislo == kon.POPISEK_IJ)
        {  // pokud se jedná o popisek i-j+1 nebo i+j-1
          jLabelij.setText(zmena.puvodniObsah);
        }
        else if (zmena.cislo == kon.POPISEK_MJ)
        {  // pokud se jedná o popisek m-j+1 nebo n-m+1
          jLabelmj.setText(zmena.puvodniObsah);
        }
        else if (zmena.cislo == kon.POPISEK_L)
        {  // pokud se jedná o popisek L nebo d1p
          jLabelL.setText(zmena.puvodniObsah);
        }
      }  // změna textu popisku
      
      if (iteratorViz.hasPrevious())
      {  // pokud je k dispozici předchozí změna
        // získání informací o předchozí změně
        zmena = (ZmenaZobrazeni)iteratorViz.previous();
      }
      else
      {  // pokud předchozí změna není k dispozici
        konec = true;  // ukončí cyklus
      }
    }  // vrácení všech změn v kroku
    
    if (zmena.cisloKroku != aktKrok)
    {  // přejel na poslední změnu předchozího kroku, je nutno se vrátit
      zmena = (ZmenaZobrazeni)iteratorViz.next();  // návrat o 1 položku vpřed
    }    
    
    aktKrok--;  // byl proveden krok zpět
      
    // aktualizuje obsah políčka s počítadlem kroků
    jLabelPocitadloKroku.setText("krok " + aktKrok + " / " + pocetKroku);
  }  // krokZpet()
   
} // public class AppletBoyerMooreDemo

/*** Konec souboru AppletBoyerMooreDemo.java ***/
