/******************************************************************************
 * Název projektu: Aplet pro demonstraci Boyerova-Mooreova algoritmu
 * Balíček: boyermooredemo
 * Soubor: ZmenaZobrazeni.java
 * Datum:  14.4.2008
 * Poslední změna: 18.4.2008
 * Autor:  Jaroslav Dytrych xdytry00
 *
 * Popis: Třída pro uchování informací o změnách zobrazení při vizualizaci.
 *        Uchovává i informace pro vrácení každého kroku pro zpětné krokování.
 *
 ******************************************************************************/

/**
 * @file ZmenaZobrazeni.java
 * 
 * @brief Třída ZmenaZobrazeni - uchování informací o změnách zobrazení při vizualizaci
 */

package boyermooredemo;

import java.awt.Color;

/**
 * Třída pro uchování informací o změnách zobrazení při vizualizaci
 * 
 * Uchovává i informace pro vrácení každého kroku pro zpětné krokování.
 * 
 * @brief Uchování informací o změnách zobrazení při vizualizaci
 */
public class ZmenaZobrazeni {
  public int cisloKroku = 0;  // číslo kroku, ke kterému změna patří
  public int operace = 0;  // udává operaci a typ prvku, který se bude měnit
  public int tabulka = 0;  // číslo tabulky
  public int radek = 0;  // řádek tabulky nebo počet řádků při změně rozměrů
  public int sloupec = 0;  // sloupec tabulky nebo počet sloupců při změně rozměrů
  public String novyObsah = null;  // nový obsah buňky v tabulce nebo políčka s proměnnou
  public String puvodniObsah = null;  // obsah buňky tabulky nebo políčka s proměnnou před změnou
  public Color barvaTextu = null;  // nová barva buňky v tabulce
  public Color barvaPozadi = null;  // nová barva pozadí buňky v tabulce
  public Color puvodniBarvaTextu = null;  // barva buňky v tabulce před změnou
  public Color puvodniBarvaPozadi = null;  // barva pozadí buňky v tabulce před změnou
  public int smer = 0;  // směr posuvu řádku v tabulce
  public int pocet = 0;  // počet posuvů řádku v tabulce
  public int puvodneRadku = 0;  // počet řádků v tabulce před změnou velikosti
  public int puvodneSloupcu = 0;  // počet sloupců v tabulce před změnou velikosti
  public int cislo = 0;  // dle operace (číslo bloku / řádku / proměnné / textu)
  public int puvodniCislo = 0;  // číslo před změnou
  
  /**
   * Konstruktor pro objekt s informacemi o změně hodnoty v buňce tabulky
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param tabulkaB Tabulka, v níž se buňka nachází
   * @param radekB Řádek, v němž se buňka nachází
   * @param sloupecB Sloupec, v němž se buňka nachází
   * @param novyObsahB Nový obsah buňky
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int tabulkaB, 
                        int radekB, int sloupecB, String novyObsahB)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    tabulka = tabulkaB;
    radek = radekB;
    sloupec = sloupecB;
    novyObsah = novyObsahB;
  }
  
  /**
   * Konstruktor pro objekt s informacemi o změně barvy buňky tabulky
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param tabulkaB Tabulka, v níž se buňka nachází
   * @param radekB Řádek, v němž se buňka nachází
   * @param sloupecB Sloupec, v němž se buňka nachází
   * @param barvaTextuB Nová barva textu v buňce
   * @param barvaPozadB Nová barva pozadí buňky
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int tabulkaB, 
                       int radekB, int sloupecB, 
                       Color barvaTextuB, Color barvaPozadB)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    tabulka = tabulkaB;
    radek = radekB;
    sloupec = sloupecB;
    barvaTextu = barvaTextuB;
    barvaPozadi = barvaPozadB;
  }
  
  /**
   * Konstruktor pro objekt s informacemi o posuvu řádku tabulky
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param tabulkaP Tabulka, v níž se bude posouvat řádek
   * @param radekP Posouvaný řádek
   * @param smerP Směr posuvu
   * @param pocetP Počet posuvů
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int tabulkaP, int radekP, 
                        int smerP, int pocetP)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    tabulka = tabulkaP;
    radek = radekP;
    smer = smerP;
    pocet = pocetP;
  }
  
  /**
   * Konstruktor pro objekt s informacemi o změně rozměrů tabulky
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param tabulkaZ Tabulka, jejíž rozměry se mají měnit
   * @param radku Nový počet řádků tabulky
   * @param sloupcu Nový počet sloupců tabulky
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int tabulkaZ, int radku, int sloupcu)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    tabulka = tabulkaZ;
    radek = radku;
    sloupec = sloupcu;
  }
  
  /**
   * Konstruktor pro objekt pro uchování informací o změně hodnoty proměnné
   * nebo popisku
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param cisloP Číslo proměnné nebo popisku
   * @param hodnotaP Nová hodnota proměnné nebo popisku v řetězci
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int cisloP, String hodnotaP)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    cislo = cisloP;
    novyObsah = hodnotaP;
  }
  
  /**
   * Konstruktor pro objekt pro uchování informací o:
   * - výměně bloku v panelu s algoritmem
   * - změně zvýrazněného řádku v poli s algoritmem
   * - změně obsahu pole s nápovědou
   *
   * @param krok Číslo kroku, ke kterému změna patří
   * @param operaceZ Prováděná operace
   * @param noveCislo
   */
  public ZmenaZobrazeni(int krok, int operaceZ, int noveCislo)
  {
    // uložení hodnot do proměnných třídy
    cisloKroku = krok;
    operace = operaceZ;
    cislo = noveCislo;
  }
}  // public class ZmenaZobrazeni

/*** Konec souboru ZmenaZobrazeni.java ***/
