#include <QObject>
#include <QString>
#include <QDateTime>
#include <QQmlEngine>

#ifndef ADDRESS_H
#define ADDRESS_H

/**
 * @brief The Address class
 * Reprezentuje zaznam v seznamu "adres"
 */
class Address : public QObject
{
    Q_OBJECT

    // Property pro jednotlive polozky zaznamu
    Q_PROPERTY(QString name READ name NOTIFY nameChanged)
    Q_PROPERTY(QString address READ address NOTIFY addressChanged)
    Q_PROPERTY(QDateTime dateTime READ dateTime NOTIFY dateTimeChanged)

public:
    Address(const QString &name = "", const QString &address = "", const QDateTime &dateTime = QDateTime::currentDateTime())
        : m_name(name), m_address(address), m_dateTime(dateTime)
    {
    }

    QString name() const { return m_name; }
    QString address() const { return m_address; }
    QDateTime dateTime() const { return m_dateTime; }

    /**
     * @brief registerType
     * Staticka metoda pro registraci typu do QML typoveho systemu
     */
    static void registerType() {
        qmlRegisterType<Address>("com.company.sample", 1, 0, "Address");
    }

signals:
    // Signaly pro notifikaci o zmnene hodnot property
    void nameChanged();
    void addressChanged();
    void dateTimeChanged();

protected:
    QString m_name;
    QString m_address;
    QDateTime m_dateTime;
};

#endif // ADDRESS_H
