
#include "address_book.h"
#include "address.h"

#include <QThread>

AddressBook::AddressBook(QObject *parent)
    : QObject(parent)
{
    m_items.append(new Address("Test", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
    m_items.append(new Address("Test 1", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
    m_items.append(new Address("Test 2", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
    m_items.append(new Address("Test 3", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
    m_items.append(new Address("Test 4", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."));
}

QQmlListProperty<Address> AddressBook::items()
{
    // Listy/pole musi byt predavany jako QQmlListProperty
    return QQmlListProperty<Address>(this, m_items);
}

void AddressBook::clearAll()
{
    for(auto &item : m_items)
        item->deleteLater();

    m_items.clear();

    emit itemsChanged();
}

void AddressBook::insertNewItem(const QString &name, const QString &address)
{
    m_items.append(new Address(name, address));

    emit itemsChanged();
}

void AddressBook::appendItem(QQmlListProperty<Address> *list, Address *item)
{
    AddressBook *addressBook = qobject_cast<AddressBook *>(list->object);

    if(item)
        addressBook->m_items.append(item);
}
