#include <QObject>
#include <QQmlListProperty>
#include <QList>

#include "address.h"

#ifndef ADDRESS_BOOK_H
#define ADDRESS_BOOK_H

/**
 * @brief The AddressBook class
 * Reprezentuje seznam zaznamu a umoznuje operace nad nimi
 */
class AddressBook : public QObject
{
    Q_OBJECT

    // Zpristupneni listu zaznamu do QML
    Q_PROPERTY(QQmlListProperty<Address> items READ items NOTIFY itemsChanged)

public:
    AddressBook(QObject *parent = nullptr);

    QQmlListProperty<Address> items();

    // Metoda, kterou lze volat z QML
    Q_INVOKABLE void insertNewItem(const QString &name, const QString &address);

public slots:
    void clearAll(); // Slot pro odstraneni vsech zaznamu z listu

signals:
    void itemsChanged(); // Notifikace o zmnene seznamu zaznamu

private:
    // Metoda umoznujici zapis do seznamu z QML (zde nevyuzita)
    static void appendItem(QQmlListProperty<Address> *list, Address *item);

protected:
    QList<Address *> m_items;
};

#endif // ADDRESS_BOOK_H
