#include <QObject>
#include <QKeyEvent>
#include <QCoreApplication>
#include <QDebug>

#include "gui_driver.h"

const QColor GUIDriver::sc_onColor = QColor(Qt::green);
const QColor GUIDriver::sc_offColor = QColor(Qt::red);

GUIDriver::GUIDriver(QObject *parent)
    : QObject(parent), m_currentColor(sc_offColor)
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(toggleColor()));
}

void GUIDriver::StartClicked()
{
    m_timer.start(1000);
}

void GUIDriver::StopClicked()
{
    m_timer.stop();
}

void GUIDriver::toggleColor()
{
    if(m_currentColor == sc_onColor)
        m_currentColor = sc_offColor;
    else
        m_currentColor = sc_onColor;

    emit colorChanged();
}
