#include <QObject>
#include <QWindow>
#include <QColor>
#include <QTimer>

#ifndef GUI_DRIVER_H
#define GUI_DRIVER_H

class GUIDriver : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QColor color READ color NOTIFY colorChanged)

public:
    GUIDriver(QObject *parent = nullptr);

    const QColor &color() { return m_currentColor; }

signals:
    void colorChanged();

public slots:
    void StartClicked();
    void StopClicked();
    void toggleColor();

protected:
    QTimer m_timer;
    QColor m_currentColor;

    static const QColor sc_onColor;
    static const QColor sc_offColor;
};

#endif // GUI_DRIVER_H
