import QtQuick 2.9
import QtQuick.Window 2.2
import QtQuick.Layouts 1.1

Window {
    visible: true
    width: 640
    height: 480
    title: qsTr("Sample App")

    ColumnLayout {
        width: parent.width
        height: parent.height

        ColumnLayout {
            width: parent.width
            Layout.fillHeight: true

            ListView {
                width: parent.width
                height: parent.height
                model: Array.from(addressBook.items)
                clip: true
                spacing: 8

                Component {
                    id: addressItem

                    Item {
                        height: itemColumn.height
                        width: parent.width

                        Column {
                            id: itemColumn
                            width: parent.width

                            Rectangle {
                                width: parent.width
                                height: 22
                                color: "gray"

                                Text { anchors.left: parent.left; height: parent.height; verticalAlignment: Text.AlignVCenter; font.bold: true; text: model.name }
                                Text { anchors.right: parent.right; height: parent.height; verticalAlignment: Text.AlignVCenter; font.bold: true; text: model.dateTime }
                            }

                            Text {
                                width: parent.width;
                                wrapMode: Text.Wrap;
                                anchors.left: parent.left;
                                text: model.address
                            }
                        }
                    }
                }

                delegate: addressItem
            }
        }

        Rectangle { width: parent.width; height: 2; color: "black" }

        RowLayout {
            id: inputBox
            width: parent.width
            height: 128
            Layout.fillHeight: false

            ColumnLayout {
                height: parent.height

                Text { text: "Name:" }

                Rectangle {
                    Layout.fillWidth: true
                    color: "transparent"
                    border.width: 1
                    height: 24

                    TextInput {
                        id: nameTextEdit;

                        anchors.fill: parent
                        anchors.margins: 4;
                        Layout.fillWidth: true;
                        verticalAlignment: Text.AlignVCenter

                        maximumLength: 16;

                        onFocusChanged: { parent.border.width = focus ? 2 : 1; }
                    }
                }

                Text { width: parent.width; height: 16; text: "Address:" }

                Rectangle {
                    Layout.fillHeight: true;
                    Layout.fillWidth: true;
                    Layout.minimumWidth: 160;
                    color: "transparent";
                    border.width: 1;

                    TextEdit {
                        id: addressTextEdit;
                        anchors.fill: parent;
                        anchors.margins: 4;

                        wrapMode: Text.WrapAnywhere;

                        onFocusChanged: { parent.border.width = focus ? 2 : 1; }
                    }
                }
            }

            ColumnLayout {
                height: parent.height

                Rectangle {
                    height: 62
                    width: parent.height
                    color: "red"
                    border.color: "white"

                    Text {
                        anchors.fill: parent
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: "white"
                        font.pointSize: 16
                        font.bold: true

                        text: "CLEAR ALL"
                    }

                    MouseArea {
                        id: clearButton
                        anchors.fill: parent

                        onPressed: { parent.border.width = 2; }
                        onReleased: { parent.border.width = 0; }

                        Connections {
                            target: clearButton
                            function onClicked() {
                                addressBook.clearAll()
                            }
                        }
                    }
                }

                Rectangle {
                    height: 62
                    width: parent.height
                    color: "green"
                    border.color: "white"

                    Text {
                        anchors.fill: parent
                        horizontalAlignment: Text.AlignHCenter
                        verticalAlignment: Text.AlignVCenter
                        color: "white"
                        font.pointSize: 16
                        font.bold: true

                        text: "INSERT"
                    }

                    MouseArea {
                        anchors.fill: parent

                        onPressed: { parent.border.width = 2; }
                        onReleased: { parent.border.width = 0; }
                        onClicked: {
                            addressBook.insertNewItem(nameTextEdit.text, addressTextEdit.text);
                            nameTextEdit.text = "";
                            addressTextEdit.text = "";
                        }
                    }
                }
            }
        }
    }
}
