/*
 * Project: Example game for creation of installer
 * Authors: Ing. Jan Kouřil
 *          Ing. Jaroslav Dytrych idytrych@fit.vutbr.cz
 * File: kufr.h
 */

/**
 * @file kufr.h
 *
 * @brief Header file for main window of program
 */

#ifndef KUFR_H
#define KUFR_H

#include <QMainWindow>
class CanvasWidget;
class QMenuBar;

/**
 * Main window of program
 */
class Kufr : public QMainWindow
{
    Q_OBJECT

private:
    /** Menu bar */
    QMenuBar *menubar;
    /** CAnvas for image */
    CanvasWidget *canvas;
    /** Action for grid size change */
    QAction *four,*six,*eight;
public:
    /** Constructor */
    Kufr(QWidget *parent = 0);

/**
 * Slots
 */
public slots:
    /**
     * Handler for Add file menu action
     */
    void aFile();
    /**
     * Handler for Add directory menu action
     */
    void aDirectory();
    /**
     * Handler for canvas resize event
     * 
     * @param w Width
     * @param h height
     */
    void resizeCanvas(int,int);
    /**
     * Handler for Grid 4x4 menu action
     */
    void set4();
    /**
     * Handler for Grid 4x4 menu action
     */
    void set6();
    /**
     * Handler for Grid 4x4 menu action
     */
    void set8();
};

#endif // KUFR_H
