/*
 * Project: Example game for creation of installer
 * Authors: Ing. Jan Kouřil
 *          Ing. Jaroslav Dytrych, Ph.D. dytrych@fit.vut.cz
 *          ChatGPT (help with upgrade to Qt 6)
 * File: kufr.h
 */

/**
 * @file kufr.h
 *
 * @brief Header file for main window of program
 */

#ifndef KUFR_H
#define KUFR_H

#include <QMainWindow>

class CanvasWidget;
class QMenuBar;
class QAction;

class Kufr : public QMainWindow
{
    Q_OBJECT

private:
    /** Menu bar */
    QMenuBar *menubar;
    /** CAnvas for image */
    CanvasWidget *canvas;
    /** Action for grid size change to four */
    QAction *four;
    /** Action for grid size change to six */
    QAction *six;
    /** Action for grid size change to eight */
    QAction *eight;

public:
    /** Constructor */
    Kufr(QWidget *parent = nullptr);

public slots:
    /**
     * Handler for Add file menu action
     */
    void aFile();
    /**
     * Handler for Add directory menu action
     */
    void aDirectory();
    /**
     * Handler for canvas resize event
     *
     * @param w Width
     * @param h height
     */
    void resizeCanvas(int w, int h);
    /**
     * Handler for Grid 4x4 menu action
     */
    void set4();
    /**
     * Handler for Grid 6x6 menu action
     */
    void set6();
    /**
     * Handler for Grid 8x8 menu action
     */
    void set8();
};

#endif // KUFR_H
