#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>

/* location of UI XML file relative to path in which program is running */
#define BUILDER_XML_FILE "glade_example.glade"

#define MAX_VALUE 9999


// struktura s ukazateli na jednotlive widgety v aplikaci
typedef struct
{
        GtkToggleButton         *toggle_button;
        GtkEntry                *entry;
        GtkComboBoxText		*combo;
	GtkCheckButton		*check;
	GtkSwitch		*switch_button;
	GtkSpinButton		*spin;
	GtkCalendar		*calendar;
	GtkTextView		*view;
	GtkButton		*button;
	GtkWidget		*window;
	GtkGrid			*grid;
	
} App;
/*
// handler, ktery je v glade prirazen stisknuti tlacitka
void on_button_clicked (GtkObject *object, App *app)
{
	int x;
	x = atoi(gtk_entry_get_text(app->entry));
	x++;
	if(x > MAX_VALUE) 
		return;

	char str[10];
	snprintf(str,10,"%d",x);
	gtk_entry_set_text(app->entry,str);
}


*/
void check_toggled(GtkCheckButton*w, GtkTextView *view){
  GtkTextBuffer *buffer = gtk_text_view_get_buffer (view);
  /* Set the default buffer text. */ 
  gtk_text_buffer_set_text (buffer, "Signal from check button!", -1);
}

void toggle_clicked(GtkToggleButton*w, GtkEntry *entry){

  gtk_entry_set_text (entry, "Signal from toggle button!");
}

void combo_changed(GtkComboBoxText*c,GtkTextView *view){
  GtkTextBuffer *buffer = gtk_text_view_get_buffer (view);
  
  gtk_text_buffer_set_text (buffer,gtk_combo_box_text_get_active_text(c),-1);
}


int main (int argc, char *argv[])
{
    App *app;
    GtkBuilder      *builder; 

    // alokuje pamet pro app	
    app = g_slice_new(App);

    gtk_init (&argc, &argv);
	
	// nacte GUI z XML
    builder = gtk_builder_new ();
    gtk_builder_add_from_file (builder, BUILDER_XML_FILE, NULL);
	
    // priradi do struktury jednotlive widgety
    app->window = GTK_WIDGET(gtk_builder_get_object (builder, "window1"));
    app->entry = GTK_ENTRY (gtk_builder_get_object (builder, "entry1"));
    app->button = GTK_BUTTON (gtk_builder_get_object (builder, "button1"));
    app->grid = GTK_GRID(gtk_builder_get_object (builder, "grid1"));
    app->combo = GTK_COMBO_BOX_TEXT (gtk_builder_get_object (builder, "comboboxtext1"));
    app->toggle_button = GTK_TOGGLE_BUTTON (gtk_builder_get_object (builder, "togglebutton1"));
    app->check = GTK_CHECK_BUTTON(gtk_builder_get_object (builder, "checkbutton1"));
    app->calendar = GTK_CALENDAR (gtk_builder_get_object (builder, "calendar1"));
    app->spin = GTK_SPIN_BUTTON (gtk_builder_get_object (builder, "spinbutton1"));
    app->view = GTK_TEXT_VIEW(gtk_builder_get_object (builder, "textview1"));
    app->switch_button = GTK_SWITCH(gtk_builder_get_object (builder, "switchbutton1"));
	
    gtk_builder_connect_signals (builder, app);

    g_object_unref (G_OBJECT (builder));
    
    g_signal_connect (app->window, "destroy", G_CALLBACK (gtk_main_quit), NULL);
        
    gtk_widget_show (app->window);                

	//hlavni smycka gtk
    gtk_main ();

    return 0;
}
