#include <gtk/gtk.h>

static void PrintHello(GtkWidget *widget, gpointer data)
{
    g_print("Hello World\n");
}

static void Activate(GtkApplication *app, gpointer userData)
{
    GtkWidget *window = gtk_application_window_new(app);
    gtk_window_set_title(GTK_WINDOW(window), "Hello World Window");
    gtk_window_set_default_size(GTK_WINDOW(window), 320, 240);
    
    GtkWidget *buttonBox = gtk_button_box_new(GTK_ORIENTATION_HORIZONTAL);
    gtk_container_add(GTK_CONTAINER(window), buttonBox);
    
    GtkWidget *button = gtk_button_new_with_label("Hello World");
    g_signal_connect(button, "clicked", G_CALLBACK(PrintHello), NULL);
//     g_signal_connect_swapped(button, "clicked", G_CALLBACK(gtk_widget_destroy), window);
    gtk_container_add(GTK_CONTAINER(buttonBox), button);
    
    gtk_widget_show_all(window);
}

int main(int argc, char *argv[])
{
    GtkApplication *app = gtk_application_new("cz.vutbr.fit.ivs", G_APPLICATION_FLAGS_NONE);
    g_signal_connect(app, "activate", G_CALLBACK(Activate), NULL);
    int status = g_application_run(G_APPLICATION(app), argc, argv);
    g_object_unref(app);

    return status;
}
