/*
 * Project: Example game for creation of installer
 * Authors: Ing. Jan Kouřil
 *          Ing. Jaroslav Dytrych, Ph.D. dytrych@fit.vut.cz
 *          ChatGPT (help with upgrade to Qt 6)
 * File: canvasWidget.h
 */

/**
 * @file canvasWidget.h
 *
 * @brief Header file for canvas for picture
 */


#ifndef CANVASWIDGET_H
#define CANVASWIDGET_H

#include <QWidget>
#include <QList>
#include <QImage>

/**
 * Canvas for picture
 */
class CanvasWidget : public QWidget
{
    Q_OBJECT

private:
    /** List of images */
    QList<QImage> list;
    /** Actual image */
    QImage actualImage;
    /** Mode (matrice dimension) */
    int mode;
    /** Matrice 4x4 */
    bool **matrix4;
    /** Matrice 6x6 */
    bool **matrix6;
    /** Matrice 8x8 */
    bool **matrix8;
    /** Index of current image in list */
    int currentIndex;

public:
    /** Constructor */
    CanvasWidget(QWidget *parent = nullptr);
    /** Destructor */
    ~CanvasWidget();
    /** Adds image */
    void addImage(const QString &imagePath);
    /**
     * Sets mode
     *
     * @param m Mode
     */
    void setMode(int m);

protected:
    /** Paints canvas */
    void paintEvent(QPaintEvent *event) override;
    /**
     * Handles mouse press event
     *
     * @param event Mouse event
     */
    void mousePressEvent(QMouseEvent *event) override;

public slots:
    /** Starts game (shows and covers first image) */
    void start();
    /** Covers matrices */
    void coverMatrices();
    /** Clear (uncovers) matrices */
    void clearMatrices();
    /** Switches to next image */
    void next();
    /** Switches to previous image */
    void prev();

signals:
    /**
     * Request for canvas resize
     *
     * @param w Width
     * @param h height
     */
    void resizeRequest(int width, int height);
    /** Request for change of status */
    void statusRequest(const QString &status);
};

#endif // CANVASWIDGET_H
