/*
 * Project: Example game for creation of installer
 * Authors: Ing. Jan Kouřil
 *          Ing. Jaroslav Dytrych idytrych@fit.vutbr.cz
 * File: canvasWidget.h
 */

/**
 * @file canvasWidget.h
 *
 * @brief Header file for canvas for picture
 */

#ifndef CANVASWIDGET_H
#define CANVASWIDGET_H

#include <QWidget>
#include "QList"
#include "QImage"

/**
 * Canvas for picture
 */
class CanvasWidget : public QWidget
{
    Q_OBJECT
private:
    /** List of images */
    QList<QImage> list;
    /** Actual image */
    QImage actualImage;
    /** Mode (matrice dimension) */
    int mode;
    /** Matrice 4x4 */
    bool **matrix4;
    /** Matrice 6x6 */
    bool **matrix6;
    /** Matrice 8x8 */
    bool **matrix8;
    /** Index of current image in list */
    int currentIndex;

public:
    /** Constructor */
    CanvasWidget(QWidget *parent = 0);
    /** Destructor */
    ~CanvasWidget();
    /** Adds image */
    void addImage(QString);
    /** 
     * Sets mode 
     * 
     * @param m Mode
     */
    void setMode(int);
protected:
    /** Paints canvas */
    void paintEvent(QPaintEvent *);
    /**
     * Handles mouse press event
     * 
     * @param e Mouse event
     */
    void mousePressEvent(QMouseEvent *);
public slots:
    /** Starts game (shows and covers first image) */
    void start();
    /** Covers matrices */
    void coverMatrices();
    /** Clear (uncovers) matrices */
    void clearMatrices();
    /** Switches to next image */
    void next();
    /** Switches to previous image */
    void prev();

signals:
    /** 
     * Request for canvas resize
     * 
     * @param w Width
     * @param h height
     */
    void resizeRequest(int,int);
    /** Request for change of status */
    void statusRequest(QString);
};

#endif // CANVASWIDGET_H
