#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>

#include "./include/mean.h"

int MAX_PATH=1000;

int main(int argc, char* argv[]) {

  double v1, v2, m;
  v1 = 5.2;
  v2 = 7.9;

  m  = mean(v1, v2);

  printf("The mean of %3.2f and %3.2f is %3.2f\n", v1, v2, m);

  // Zápis výsledku do souboru
  char path[MAX_PATH];
  snprintf(path, MAX_PATH, "%s", getenv("HOME"));
  strcat(path,"/0_meancalc");
  struct stat st = {0};
  if (stat(path, &st) == -1) {
    mkdir(path, 0700);
  }
  strcat(path,"/meanResult.txt");
  FILE *fp = fopen(path, "w");
  if (fp == NULL) {
    printf("%s", path);
    exit(-1);
  }
  fprintf(fp, "The mean of %3.2f and %3.2f is %3.2f\n", v1, v2, m);
  fclose(fp);

  return 0;
}